/* pgmigrate-encoding: utf-8 */

update product_lines
set description = 'legacy line with order num ' || order_num
where id in (
    select id
    from product_lines
    where description is null);

create unique index product_lines_description_uindex
    on product_lines (description);

create or replace function setup_start_discount(product_code text, period_code text, currencyval text,
                                                start_period_duration_unit duration_measurement,
                                                start_period_length numeric, start_period_countval numeric,
                                                start_price numeric) returns integer
    language plpgsql
as
$$
declare
    affected numeric;
BEGIN
    update user_product_periods upp
    set start_period_count                         = start_period_countVal,
        start_period_discount_duration_length      = start_period_length,
        start_period_discount_duration_measurement = start_period_duration_unit
    where id in (
        select upp.id
        from user_products up
                 join user_product_periods upp on up.id = upp.user_product_id
        where up.code = product_code
          and upp.period = period_code
    );
    GET DIAGNOSTICS affected = ROW_COUNT;
    assert affected = 1;

    update user_product_prices
    set start_period_price = start_price
    where id = (select u.id
                from user_products up
                         join user_product_periods upp on up.id = upp.user_product_id
                         join user_product_prices u on upp.id = u.user_product_period_id
                where up.code = product_code
                  and upp.period = period_code
                  and u.currency = currencyVal);
    GET DIAGNOSTICS affected = ROW_COUNT;
    assert affected = 1;
    RETURN 0;
END
$$;

do
$$
    declare
        product_count_before numeric;
        product_count_after  numeric;
        affected             numeric;
        product              text;
    begin
        product_count_before = (select count(1) from user_products);
        perform copy_products('mail_pro_b2c_premium200_start_discount30_v20220414_exp3', 'discount30',
                              'discount30_year_only');
        perform copy_products('mail_pro_b2c_premium1000_start_discount30_v20220414_exp3', 'discount30',
                              'discount30_year_only');
        perform copy_products('mail_pro_b2c_premium3000_start_discount30_v20220414_exp3', 'discount30',
                              'discount30_year_only');
        affected := 0;
        for product in (select code
                        from user_products
                        where code like '%mail_pro_b2c_premium%_start_discount30_year_only_v20220414_exp3%')
            LOOP
                affected := affected+1;
                perform setup_start_discount(product, 'month', 'RUB', null, null, null, null);
                perform setup_start_discount(product, 'month', 'USD', null, null, null, null);
            END LOOP;
        assert affected = 3;

        perform create_product_line('mail_pro_b2c',
                                    'web start discount 30% year only exp v3',
                                    (select order_num
                                     from product_lines
                                     where description = 'web start discount 30% exp v3'),
                                    array ['mail_pro_b2c_premium200_start_discount30_year_only_v20220414_exp3',
                                        'mail_pro_b2c_premium1000_start_discount30_year_only_v20220414_exp3',
                                        'mail_pro_b2c_premium3000_start_discount30_year_only_v20220414_exp3']);
        update promo_product_lines
        set product_line_id = (
            select id from product_lines where description = 'web start discount 30% year only exp v3')
        where product_line_id = (
            select id from product_lines where description = 'web start discount 30% exp v3');

        GET DIAGNOSTICS affected = ROW_COUNT;
        assert affected = 1;

        product_count_after = (select count(1) from user_products);
        assert product_count_after - product_count_before = 3;

    end;
$$ LANGUAGE plpgsql;
