/* pgmigrate-encoding: utf-8 */
CREATE OR REPLACE FUNCTION on_product_line_delete() RETURNS TRIGGER AS
$$
BEGIN
    IF (TG_OP = 'DELETE') THEN
        IF(SELECT TRUE
           FROM user_product_buckets b
           where b.product_set_id = OLD.product_set_id
           limit 1) THEN
            RAISE EXCEPTION 'Unable to delete product line % because its productset exists in bucket of conflicting products', OLD.id;
        END IF;
        IF(SELECT TRUE
           FROM user_product_buckets b
           where b.product_line_id = OLD.id
           limit 1) THEN
            RAISE EXCEPTION 'Unable to delete product line % because it exists in bucket of conflicting products', OLD.id;
        END IF;
    END IF;
    RETURN OLD;
END;
$$ LANGUAGE plpgsql VOLATILE;

CREATE OR REPLACE FUNCTION on_delete_product_from_product_line() RETURNS TRIGGER AS
$$
BEGIN
    IF (TG_OP = 'DELETE') THEN
        IF(SELECT TRUE
           FROM user_product_buckets b
           where b.user_product_id = OLD.user_product_id
           limit 1) THEN
            RAISE EXCEPTION 'Unable to delete user product % from product line % because user product exists in bucket of conflicting products', OLD.user_product_id, OLD.product_line_id;
        END IF;
        IF(SELECT TRUE
           FROM user_product_buckets b
           where b.product_line_id = OLD.product_line_id
           limit 1) THEN
            RAISE EXCEPTION 'Unable to delete user product % from product line % because product line exists in bucket of conflicting products', OLD.user_product_id, OLD.product_line_id;
        END IF;
        IF(SELECT TRUE
           FROM user_product_buckets b
                    join product_lines pl on b.product_set_id = pl.product_set_id
           where pl.id = OLD.product_line_id
           limit 1) THEN
            RAISE EXCEPTION 'Unable to delete user product % from product line % because product set exists in bucket of conflicting products', OLD.user_product_id, OLD.product_line_id;
        END IF;
    END IF;
    RETURN OLD;
END;
$$ LANGUAGE plpgsql VOLATILE;
