/* pgmigrate-encoding: utf-8 */

-- логика скопирована из create_product_line, кроме того, что продукты добавляются в group_products_to_product_lines
create or replace function create_group_product_line(product_set_key text, new_line_description text,
                                                     new_product_line_order numeric, product_codes text[],
                                                     selector text DEFAULT 'productLineSelectorFactory.availableSelector()'::text)
                                                     returns void
    language plpgsql
as
$$
declare
    new_product_line_id              uuid;
    target_product_set_id            uuid;
    base_product_line_order_occupied boolean;
BEGIN
    target_product_set_id := (select id from product_sets where key = product_set_key);

    ASSERT target_product_set_id is not null, 'base product line id not resolved';

    select count(*) > 0
    into base_product_line_order_occupied
    from product_lines
    where product_set_id = target_product_set_id
      and order_num = new_product_line_order;

    if base_product_line_order_occupied then
        update product_lines
        set order_num = order_num + 1
        where product_set_id = target_product_set_id
          and order_num >= new_product_line_order;
    end if;

    insert into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
    values (target_product_set_id,
            now(),
            new_product_line_order,
            selector,
            new_line_description)
    returning id into new_product_line_id;

    -- add products
    for i in 1..array_upper(product_codes, 1)
        loop
            insert into group_products_to_product_lines (product_line_id, group_product_id, order_num)
            values (new_product_line_id,
                    (select id from group_products where code = product_codes[i]),
                    i);
        end loop;
END
$$;

do
$$
    declare
        before_products_count  int;
        after_products_count  int;
        before_group_products_count  int;
        after_group_products_count  int;
        new_product_lines_count  int;
        before_product_lines_count  int;
        after_product_lines_count  int;
        new_product_line_id UUID;
    begin
        before_products_count = (select count(*) from user_products);
        before_group_products_count = (select count(*) from group_products);
        before_product_lines_count = (select count(*) from product_lines);

        perform copy_group_product('prepaid_org_mail_pro_standard100_late_april_2022', 'prepaid_org_mail_pro_standard100_june_2022');
        perform copy_group_product('prepaid_org_mail_pro_optimal1000_late_april_2022', 'prepaid_org_mail_pro_optimal1000_june_2022_discount20');
        perform copy_group_product('prepaid_org_mail_pro_optimal1000_late_april_2022', 'prepaid_org_mail_pro_optimal1000_june_2022_discount25');

        -- продукты с sso
        perform copy_group_product('prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled', 'prepaid_org_mail_pro_optimal1000_june_2022_discount20_sso_enabled');
        perform copy_group_product('prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled', 'prepaid_org_mail_pro_optimal1000_june_2022_discount25_sso_enabled');

        -- меняем цены на новые продукты
        update group_products set price = 279
        where code = 'prepaid_org_mail_pro_standard100_june_2022';

        update group_products set price = 439
        where code = 'prepaid_org_mail_pro_optimal1000_june_2022_discount20'
           or code = 'prepaid_org_mail_pro_optimal1000_june_2022_discount20_sso_enabled';

        update group_products set price = 419
        where code = 'prepaid_org_mail_pro_optimal1000_june_2022_discount25'
           or code = 'prepaid_org_mail_pro_optimal1000_june_2022_discount25_sso_enabled';

        -- создаём новые линейки с sso
        perform create_group_product_line('mail_pro_b2b',
                                   'prepaid for b2b 360 june 2022 exp sso',
                                    201,
                                   array ['prepaid_org_mail_pro_standard100_june_2022',
                                       'prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled',
                                       'prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled'],
                                          'productLineSelectorFactory.compositeAndSelector(productLineSelectorFactory.prepaidSelector(), productLineSelectorFactory.experimentIsActiveSelector("b2b_360_exp_june_2022_baseup"), productLineSelectorFactory.experimentByOwnerIsActiveSelector("b2b_360_sso_enabled"))');

        perform create_group_product_line('mail_pro_b2b',
                                          'prepaid for b2b 360 june 2022 exp optimal discount20 sso',
                                          202,
                                          array ['prepaid_org_mail_pro_standard100_june_2022',
                                              'prepaid_org_mail_pro_optimal1000_june_2022_discount20_sso_enabled',
                                              'prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled'],
                                          'productLineSelectorFactory.compositeAndSelector(productLineSelectorFactory.prepaidSelector(), productLineSelectorFactory.experimentIsActiveSelector("b2b_360_exp_june_2022_baseup_optdown20"), productLineSelectorFactory.experimentByOwnerIsActiveSelector("b2b_360_sso_enabled"))');

        perform create_group_product_line('mail_pro_b2b',
                                          'prepaid for b2b 360 june 2022 exp optimal discount25 sso',
                                          203,
                                          array ['prepaid_org_mail_pro_standard100_june_2022',
                                              'prepaid_org_mail_pro_optimal1000_june_2022_discount25_sso_enabled',
                                              'prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled'],
                                          'productLineSelectorFactory.compositeAndSelector(productLineSelectorFactory.prepaidSelector(), productLineSelectorFactory.experimentIsActiveSelector("b2b_360_exp_june_2022_baseup_optdown25"), productLineSelectorFactory.experimentByOwnerIsActiveSelector("b2b_360_sso_enabled"))');

        -- создаём новые линейки без sso
        perform create_group_product_line('mail_pro_b2b',
                                          'prepaid for b2b 360 june 2022 exp',
                                          204,
                                          array ['prepaid_org_mail_pro_standard100_june_2022',
                                              'prepaid_org_mail_pro_optimal1000_late_april_2022',
                                              'prepaid_org_mail_pro_advanced3000_late_april_2022'],
                                          'productLineSelectorFactory.compositeAndSelector(productLineSelectorFactory.prepaidSelector(), productLineSelectorFactory.experimentIsActiveSelector("b2b_360_exp_june_2022_baseup"))');

        perform create_group_product_line('mail_pro_b2b',
                                          'prepaid for b2b 360 june 2022 exp optimal discount20',
                                          205,
                                          array ['prepaid_org_mail_pro_standard100_june_2022',
                                              'prepaid_org_mail_pro_optimal1000_june_2022_discount20',
                                              'prepaid_org_mail_pro_advanced3000_late_april_2022'],
                                          'productLineSelectorFactory.compositeAndSelector(productLineSelectorFactory.prepaidSelector(), productLineSelectorFactory.experimentIsActiveSelector("b2b_360_exp_june_2022_baseup_optdown20"))');

        perform create_group_product_line('mail_pro_b2b',
                                          'prepaid for b2b 360 june 2022 exp optimal discount25',
                                          206,
                                          array ['prepaid_org_mail_pro_standard100_june_2022',
                                              'prepaid_org_mail_pro_optimal1000_june_2022_discount25',
                                              'prepaid_org_mail_pro_advanced3000_late_april_2022'],
                                          'productLineSelectorFactory.compositeAndSelector(productLineSelectorFactory.prepaidSelector(), productLineSelectorFactory.experimentIsActiveSelector("b2b_360_exp_june_2022_baseup_optdown25"))');

        -- checks
        after_products_count = (select count(*) from user_products);
        ASSERT after_products_count - before_products_count = 5;

        after_group_products_count = (select count(*) from group_products);
        ASSERT after_group_products_count - before_group_products_count = 5;

        after_product_lines_count = (select count(*) from product_lines);
        new_product_lines_count = after_product_lines_count - before_product_lines_count;
        ASSERT new_product_lines_count = 6;
        ASSERT new_product_lines_count = (select count(*) from product_lines where description like 'prepaid for b2b 360 june 2022 exp%');

        FOR new_product_line_id IN (select id from product_lines where description like 'prepaid for b2b 360 june 2022 exp%')
            LOOP
                ASSERT 3 = (select count(*)
                            from group_products_to_product_lines
                            where product_line_id = new_product_line_id);
            END LOOP;

    end
$$ LANGUAGE plpgsql;
