/* pgmigrate-encoding: utf-8 */

do
$$
    declare
        new_products_count  int;
        before_products_count  int;
        after_products_count  int;
        new_product_line_id UUID;
    begin
        before_products_count = (select count(*) from user_products);
        perform copy_products('mail_pro_b2c_premium1000_v20220414_exp3', 'mail_pro_b2c_premium1000_v20220414_exp3', 'mail_pro_b2c_premium1000_start_discount_2y_v20220414_exp3');
        perform copy_products('mail_pro_b2c_premium3000_v20220414_exp3', 'mail_pro_b2c_premium3000_v20220414_exp3', 'mail_pro_b2c_premium3000_start_discount_2y_v20220414_exp3');

        perform setup_start_discount('mail_pro_b2c_premium1000_start_discount_2y_v20220414_exp3', 'year', 'RUB', 'year', 2, 1, 2290);
        perform setup_start_discount('mail_pro_b2c_premium1000_start_discount_2y_v20220414_exp3', 'year', 'USD', 'year', 2, 1, 28.99);
        perform setup_start_discount('mail_pro_b2c_premium3000_start_discount_2y_v20220414_exp3', 'year', 'RUB', 'year', 2, 1, 5690);
        perform setup_start_discount('mail_pro_b2c_premium3000_start_discount_2y_v20220414_exp3', 'year', 'USD', 'year', 2, 1, 71.99);

        perform create_product_line('mail_pro_b2c',
                                   'web start discount 2 years exp v3',
                                   (select order_num from product_lines
                                                       where description = 'web start discount 30% year only exp v3'), -- взял линейку с прошлой акции в июне
                                   array ['mail_pro_b2c_premium200_v20220414_exp3',
                                       'mail_pro_b2c_premium1000_start_discount_2y_v20220414_exp3',
                                       'mail_pro_b2c_premium3000_start_discount_2y_v20220414_exp3']);

        insert into promo_templates
        (code, description, promo_name_tanker_key_id,
         from_date, to_date,
         application_area, application_type,
         duration, duration_measurement, activation_email_template_key, created_at)
        values ('july_web_2022', 'Акция июль 2022', null,
                '2022-07-11T00:00:00.000+0300' AT TIME ZONE 'UTC', null,
                'per_user'::promo_application_area, 'multiple_time'::promo_application_type,
                10, 'day', null, now());

        perform link_promo('web start discount 2 years exp v3', 'july_web_2022');

        perform create_promo_payload('july_web_2022', 'web_mail'::payload_type, '{
 "discountPercent": 30,
 "onboarding": {
    "title_tanker": {
      "tanker_project": "mail-liza",
      "tanker_key_set": "custom-promo",
      "tanker_key": "2022_June_20_Onboarding_Header"
    },
    "background": "https://yastatic.net/s3/disk/promo/june-2022/web-disk/onboarding/bg.jpg",
    "illustration": "https://yastatic.net/s3/disk/promo/june-2022/web-disk/onboarding/pic.png",
    "benefits": [
      {
        "text_tanker": {
          "tanker_project": "mail-liza",
          "tanker_key_set": "custom-promo",
          "tanker_key": "2022_June_20_Onboarding_Benefit_domain"
        },
        "url": "https://yastatic.net/s3/disk/promo/common/web-disk/onboarding/benefit-domain.svg"
      },
      {
        "text_tanker": {
          "tanker_project": "mail-liza",
          "tanker_key_set": "custom-promo",
          "tanker_key": "2022_June_20_Onboarding_Benefit_ads"
        },
        "url": "https://yastatic.net/s3/disk/promo/common/web-disk/onboarding/benefit-chat.svg"
      },
      {
        "text_tanker": {
          "tanker_project": "mail-liza",
          "tanker_key_set": "custom-promo",
          "tanker_key": "2022_June_20_Onboarding_Benefit_space"
        },
        "url": "https://yastatic.net/s3/disk/promo/common/web-disk/onboarding/benefit-cloud.svg"
      },
      {
        "text_tanker": {
          "tanker_project": "mail-liza",
          "tanker_key_set": "custom-promo",
          "tanker_key": "2022_June_20_Onboarding_Benefit_other"
        },
        "url": "https://yastatic.net/s3/disk/promo/common/web-disk/onboarding/benefit-effects.svg"
      }
    ]
  }
}', 0);

        perform create_promo_payload('july_web_2022', 'web_disk'::payload_type,'{
 "discountPercent": 30,
 "onboarding": {
    "title_tanker": {
      "tanker_project": "yandex_disk_web",
      "tanker_key_set": "custom-promo",
      "tanker_key": "ufo_subscription_onboarding_June_20_2022_heading"
    },
    "background": "https://yastatic.net/s3/disk/promo/june-2022/web-disk/onboarding/bg.jpg",
    "illustration": "https://yastatic.net/s3/disk/promo/june-2022/web-disk/onboarding/pic.png",
    "benefits": [
      {
        "text_tanker": {
          "tanker_project": "yandex_disk_web",
          "tanker_key_set": "custom-promo",
          "tanker_key": "ufo_subscription_onboarding_June_20_2022_benefit_space"
        },
        "url": "https://yastatic.net/s3/disk/promo/common/web-disk/onboarding/benefit-cloud.svg"
      },
      {
        "text_tanker": {
          "tanker_project": "yandex_disk_web",
          "tanker_key_set": "custom-promo",
          "tanker_key": "ufo_subscription_onboarding_June_20_2022_benefit_unlim"
        },
        "url": "https://yastatic.net/s3/disk/promo/common/web-disk/onboarding/benefit-unlim.svg"
      },
      {
        "text_tanker": {
          "tanker_project": "yandex_disk_web",
          "tanker_key_set": "custom-promo",
          "tanker_key": "ufo_subscription_onboarding_June_20_2022_benefit_ads"
        },
        "url": "https://yastatic.net/s3/disk/promo/common/web-disk/onboarding/benefit-chat.svg"
      },
      {
        "text_tanker": {
          "tanker_project": "yandex_disk_web",
          "tanker_key_set": "custom-promo",
          "tanker_key": "ufo_subscription_onboarding_June_20_2022_benefit_other"
        },
        "url": "https://yastatic.net/s3/disk/promo/common/web-disk/onboarding/benefit-effects.svg"
      }
    ]
  }
}
',0);
            --checks
        after_products_count = (select count(*) from user_products);
        new_products_count = after_products_count - before_products_count;
        ASSERT new_products_count = 2;
        ASSERT exists(select * from product_lines where description = 'web start discount 2 years exp v3');
        new_product_line_id := (select id
                                from product_lines
                                where description = 'web start discount 2 years exp v3');

        ASSERT new_products_count = (select count(*)
                                     from user_products
                                     where code like 'mail_pro_b2c_premium%_start_discount_2y_v20220414_exp3');

        ASSERT 3 = (select count(*)
                    from user_products_to_product_lines
                    where product_line_id = new_product_line_id);
        ASSERT exists(select *
                      from promo_product_lines
                      where product_line_id = new_product_line_id
                      and promo_template_id = (select id from promo_templates where code = 'july_web_2022'));

        Assert 1 = (select count(*)
                    from user_products_to_product_lines
                    join user_products up on user_products_to_product_lines.user_product_id = up.id
                    where product_line_id = new_product_line_id
                      and up.is_best_offer = true);
    end
$$ LANGUAGE plpgsql;
