/* pgmigrate-encoding: utf-8 */
WITH mpfs(host) AS (SELECT case
                               when (select (select value from environment where key = 'env') in ('prod', 'prestable'))
                                   then 'mpfs.disk.yandex.net'
                               else 'mpfs-stable.dst.yandex.net'
                               end)
insert
into features (code, created_at, updated_at, system_tvm_id, type, description, system_name,
               activation_url_http_method, activation_url_template,
               activation_body_template, activation_content_type,
               set_amount_url_http_method, set_amount_url_template,
               set_amount_body_template, set_amount_content_type,
               deactivation_url_http_method, deactivation_url_template,
               deactivation_body_template, deactivation_content_type,
               call_set_amount_on_activation, call_set_amount_on_deactivation, error_processor_name)
values ('unlimited_photo_autouploading_allowed', now(), now(), null, 'toggleable', 'Фото безлимит', 'mpfs',
        'POST', 'https://' || (select host from mpfs) ||
                '/json/set_ps_billing_feature?uid=#{uid}&feature_name=unlimited_photo_autouploading_allowed&value=1',
        null, null, null, null, null, null,
        'POST', 'https://' || (select host from mpfs) ||
                '/json/set_ps_billing_feature?uid=#{uid}&feature_name=unlimited_photo_autouploading_allowed&value=0',
        null, null, false, false, 'mpfs');

WITH mpfs(host) AS (SELECT case
                               when (select (select value from environment where key = 'env') in ('prod', 'prestable'))
                                   then 'mpfs.disk.yandex.net'
                               else 'mpfs-stable.dst.yandex.net'
                               end)
insert
into features (code, created_at, updated_at, system_tvm_id, type, description, system_name,
               activation_url_http_method, activation_url_template,
               activation_body_template, activation_content_type,
               set_amount_url_http_method, set_amount_url_template,
               set_amount_body_template, set_amount_content_type,
               deactivation_url_http_method, deactivation_url_template,
               deactivation_body_template, deactivation_content_type,
               call_set_amount_on_activation, call_set_amount_on_deactivation, error_processor_name)
values ('unlimited_video_autouploading_allowed', now(), now(), null, 'toggleable', 'Видео безлимит', 'mpfs',
        'POST', 'https://' || (select host from mpfs) ||
                '/json/set_ps_billing_feature?uid=#{uid}&feature_name=unlimited_video_autouploading_allowed&value=1',
        null, null, null, null, null, null,
        'POST', 'https://' || (select host from mpfs) ||
                '/json/set_ps_billing_feature?uid=#{uid}&feature_name=unlimited_video_autouploading_allowed&value=0',
        null, null, false, false, 'mpfs');


-- photo and video unlim for b2b and b2c products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at, description_tanker_key_id,
                              group_tanker_key_id, value_tanker_key_id, code, enabled, scope)
select distinct 999,
                pf.user_product_id,
                (select id from features where code = 'unlimited_photo_autouploading_allowed'),
                1,
                now(),
                cast(null as uuid),
                cast(null as uuid),
                cast(null as uuid),
                'mpfs_photo_unlim',
                false,
                'user' :: feature_scope
from product_features pf
         join user_products up on up.id = pf.user_product_id
where pf.code = 'mail_pro_b2c_unlim_mobile_video'
   or exists(select * from group_products gp where gp.user_product_id = up.id and price > 0);


insert into product_features (order_num, user_product_id, feature_id, amount, created_at, description_tanker_key_id,
                              group_tanker_key_id, value_tanker_key_id, code, enabled, scope)
select distinct 999,
                pf.user_product_id,
                (select id from features where code = 'unlimited_video_autouploading_allowed'),
                1,
                now(),
                cast(null as uuid),
                cast(null as uuid),
                cast(null as uuid),
                'mpfs_video_unlim',
                false,
                'user' :: feature_scope
from product_features pf
         join user_products up on up.id = pf.user_product_id
where pf.code = 'mail_pro_b2c_unlim_mobile_video'
   or exists(select * from group_products gp where gp.user_product_id = up.id and price > 0);


-- --enable features
-- update product_features
-- set enabled = true
-- where code in ('mpfs_photo_unlim', 'mpfs_video_unlim');
--
--
-- --update user_services
-- update user_services
-- set status            = 'init',
--     updated_at        = now(),
--     status_updated_at = now()
-- where target = 'enabled'
--   and id in (select id
--              from user_services
--              where user_product_id in (select pf.user_product_id
--                                        from product_features pf
--                                        where code in ('mpfs_photo_unlim', 'mpfs_video_unlim')));
