/* pgmigrate-encoding: utf-8 */

CREATE TABLE group_promo_code_activations
(
    id             UUID                     DEFAULT uuid_generate_v4()  NOT NULL PRIMARY KEY,
    created_at     TIMESTAMP WITH TIME ZONE DEFAULT current_timestamp   NOT NULL,
    code           TEXT REFERENCES promo_codes (code) ON DELETE CASCADE NOT NULL,
    group_id       UUID REFERENCES groups (id) ON DELETE CASCADE        NOT NULL,
    group_promo_id UUID REFERENCES group_promos (id) ON DELETE CASCADE  NOT NULL,
    uid            TEXT                                                 NOT NULL,
    UNIQUE (group_id, code)
);

COMMENT
ON TABLE group_promo_code_activations IS 'Список активированных промо кодов для группы';

COMMENT
ON COLUMN group_promo_code_activations.id IS 'Идентификатор';
COMMENT
ON COLUMN group_promo_code_activations.created_at IS 'Дата создания';
COMMENT
ON COLUMN group_promo_code_activations.code IS 'Промо код';
COMMENT
ON COLUMN group_promo_code_activations.group_id IS 'Группа';
COMMENT
ON COLUMN group_promo_code_activations.group_promo_id IS 'Промо акция для группы';
COMMENT
ON COLUMN group_promo_code_activations.uid IS 'Пользователь который активировал промокод';

CREATE INDEX group_promo_code_activations_group_id_idx ON group_promo_code_activations (group_id);
CREATE INDEX group_promo_code_activations_group_promo_id_idx ON group_promo_code_activations (group_promo_id);
CREATE INDEX group_promo_code_activations_code_idx ON group_promo_code_activations (code);
