/* pgmigrate-encoding: utf-8 */

-- increased filesize limit for all products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at, description_tanker_key_id,
                              group_tanker_key_id, value_tanker_key_id, code, enabled, scope)
select 12,
       up.id,
       null,
       1,
       now(),
       (select id
        from tanker_keys
        where project = 'disk-ps-billing'
          and key_set = 'features'
          and key = 'mail_pro_increased_filesize_limit'),
       (select id
        from tanker_keys
        where project = 'disk-ps-billing'
          and key_set = 'features'
          and key = 'mail_pro_b2c_group_disk'),
       null,
       'increased_filesize_limit',
       true,
       'user' :: feature_scope
from user_products up
where up.code not like '%light%'
  and up.billing_type != 'free'
  and not exists(select *
                 from group_products gp
                 where gp.user_product_id = up.id and gp.price = 0);
