/* pgmigrate-encoding: utf-8 */

create or replace function change_product_line_order_num(
    product_set_key text,
    line_description text,
    new_line_order numeric
) returns void
    language plpgsql
as
$$
declare
    target_product_set_id              uuid;
    base_product_line_order_occupied boolean;
BEGIN
    target_product_set_id := (select id from product_sets where key = product_set_key);

    ASSERT target_product_set_id is not null, 'base product line id not resolved';

    select count(*) > 0
    into base_product_line_order_occupied
    from product_lines
    where product_set_id = target_product_set_id
      and order_num = new_line_order;

    if base_product_line_order_occupied then
        update product_lines
        set order_num = order_num + 1
        where product_set_id = target_product_set_id
          and order_num >= new_line_order;
    end if;

    update product_lines
    set order_num = new_line_order
    where product_set_id = target_product_set_id
      and description = line_description;
END
$$;

select change_product_line_order_num('mail_pro_b2c',
    'web start discount 2 years exp v3',
    (select order_num from product_lines
                  where description = 'web default line exp control discount 20')
);
