/* pgmigrate-encoding: utf-8 */

-- добавляем новые продукты
select copy_group_product('prepaid_org_mail_pro_edu_standard100_late_april_2022',
                          'prepaid_org_mail_pro_edu_standard100_late_april_2022_sso_enabled');
select copy_group_product('prepaid_org_mail_pro_edu_optimal1000_late_april_2022_trial_1y',
                          'prepaid_org_mail_pro_edu_optimal1000_late_april_2022_sso_enabled_trial_1y');
select copy_group_product('prepaid_org_mail_pro_edu_advanced3000_late_april_2022',
                          'prepaid_org_mail_pro_edu_advanced3000_late_april_2022_sso_enabled');

-- добавляем в них фичу с ССО
insert into product_features(user_product_id, feature_id, amount, created_at, description_tanker_key_id, enabled,
                             group_tanker_key_id, value_tanker_key_id, order_num, code, scope)
select p.id,
       f.id,
       1,
       now(),
       (select id from tanker_keys where project = 'disk-ps-billing' and key_set = 'features' and key = 'sso'),
       true,
       (select id
        from tanker_keys
        where project = 'disk-ps-billing'
          and key_set = 'features'
          and key = 'mail_pro_b2c_group_disk'),
       null,
       38,
       f.code,
       'group'
from user_products p,
     features f
where p.code in (
                 'prepaid_org_mail_pro_edu_standard100_late_april_2022_sso_enabled',
                 'prepaid_org_mail_pro_edu_optimal1000_late_april_2022_sso_enabled_trial_1y'
--                  'prepaid_org_mail_pro_edu_advanced3000_late_april_2022_sso_enabled' -- уже есть, но выключена
    )
  and f.code = 'sso';

-- включаем выключенную фичу
update product_features
set enabled = true
where id in (
    select pf.id
    from group_products g
             join user_products up on g.user_product_id = up.id
             join product_features pf on up.id = pf.user_product_id
    where g.code = 'prepaid_org_mail_pro_edu_advanced3000_late_april_2022_sso_enabled'
      and pf.code = 'sso'
);

-- создаём новую линейку с новыми продуктами
with promo_line_id as (
    insert into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
        values ((select id from product_sets where key = 'mail_pro_b2b'), now(), 101,
                'productLineSelectorFactory.compositeAndSelector(productLineSelectorFactory.prepaidSelector(), productLineSelectorFactory.educationalGroupProductSelector())',
                '[edu] prepaid for b2b 360 late april 2022')
        returning id
),
     order_num as (
         select code, order_num
         from (values ('prepaid_org_mail_pro_edu_standard100_late_april_2022_sso_enabled', 1),
                      ('prepaid_org_mail_pro_edu_optimal1000_late_april_2022_sso_enabled_trial_1y', 2),
                      ('prepaid_org_mail_pro_edu_advanced3000_late_april_2022_sso_enabled', 3)
              ) s(code, order_num)
     )
insert
into group_products_to_product_lines
    (product_line_id, group_product_id, order_num)
    (select promo_line_id.id, gp.id, order_num
     from promo_line_id,
          group_products gp
              join order_num o on gp.code like o.code);

-- чистим старые линейки чтоб не мешались
delete
from product_lines
where description in
      (
          -- удаляем старые триальные линейки. prepaid for b2b 360 late april 2022 - актуалные
       'prepaid for b2b 360 april 2022 (advanced trial)',
       'prepaid for b2b 360 april 2022 (optimal trial)',
       'prepaid for b2b 360 april 2022 (standard trial)',
       'prepaid for b2b 360 (optimal trial)',
       'prepaid for b2b 360 (advanced trial)',
       'prepaid for b2b 360 (standard trial)',
          -- удаляем старые обычные предоплатные линейки prepaid for b2b 360 late april 2022
       'prepaid for b2b 360 april 2022',
       'prepaid for b2b 360',
          -- удаляем старые образовательные линейки. Будут заменены новой
       'edu prepaid for b2b 360',
       'edu prepaid for b2b 360 late april 2022'
          );

-- даем понятное название постоплатным линейкам
update product_lines
set description = 'edu postpaid for b2b 360'
where description = 'legacy line with order num 401';
update product_lines
set description = 'postpaid for b2b 360'
where description = 'legacy line with order num 501';

-- чистим бины для простоты понимания и скорости работы. Заодно обновляем порядковые номера.
update product_lines
set selector_bean_el = 'productLineSelectorFactory.compositeAndSelector(productLineSelectorFactory.availableUntilSelector("2022-09-01", productLineSelectorFactory.prepaidSelector()), productLineSelectorFactory.experimentByOwnerIsActiveSelector("auto_pay_standard_trial"))',
    order_num        = 200
where description = 'prepaid for b2b 360 late april 2022 (standard trial)';

update product_lines
set selector_bean_el = 'productLineSelectorFactory.compositeAndSelector(productLineSelectorFactory.availableUntilSelector("2022-09-01", productLineSelectorFactory.prepaidSelector()), productLineSelectorFactory.experimentByOwnerIsActiveSelector("auto_pay_optimal_trial"))',
    order_num        = 200
where description = 'prepaid for b2b 360 late april 2022 (optimal trial)';

update product_lines
set selector_bean_el = 'productLineSelectorFactory.compositeAndSelector(productLineSelectorFactory.availableUntilSelector("2022-09-01", productLineSelectorFactory.prepaidSelector()), productLineSelectorFactory.experimentByOwnerIsActiveSelector("auto_pay_advanced_trial"))',
    order_num        = 200
where description = 'prepaid for b2b 360 late april 2022 (advanced trial)';

update product_lines
set selector_bean_el = 'productLineSelectorFactory.prepaidSelector()',
    order_num        = 301
where description = 'prepaid for b2b 360 late april 2022';

