/* pgmigrate-encoding: utf-8 */
WITH mpfs(host) AS (SELECT case
                               when (select (select value from environment where key = 'env') in ('prod', 'prestable'))
                                   then 'mpfs.disk.yandex.net'
                               else 'mpfs-stable.dst.yandex.net'
                               end)
insert
into features (code, created_at, updated_at, system_tvm_id, type, description, system_name,
               activation_url_http_method, activation_url_template,
               activation_body_template, activation_content_type,
               set_amount_url_http_method, set_amount_url_template,
               set_amount_body_template, set_amount_content_type,
               deactivation_url_http_method, deactivation_url_template,
               deactivation_body_template, deactivation_content_type,
               call_set_amount_on_activation, call_set_amount_on_deactivation, error_processor_name)
values ('public_settings_enabled', now(), now(), null, 'toggleable', 'Включение расширенных настроек шаринга', 'mpfs',
        'POST', 'https://' || (select host from mpfs) ||
                '/json/set_ps_billing_feature?uid=#{uid}&feature_name=public_settings_enabled&value=1',
        null, null, null, null, null, null,
        'POST', 'https://' || (select host from mpfs) ||
                '/json/set_ps_billing_feature?uid=#{uid}&feature_name=public_settings_enabled&value=0',
        null, null, false, false, 'mpfs_with_skip_not_initialized');


-- create tanker kay
insert into tanker_keys(created_at, project, key_set, key)
values (now(), 'disk-ps-billing', 'features', 'mail_pro_b2c_advanced_sharing');


-- add to products
insert into product_features (order_num, user_product_id, feature_id, amount, created_at, code, enabled,
                              description_tanker_key_id, group_tanker_key_id, value_tanker_key_id, scope)
select distinct 999,
                up.id,
                (select id from features where code = 'public_settings_enabled'),
                1,
                now(),
                'public_settings_enabled',
                true,
                cast(null as uuid),
                (select id
                 from tanker_keys
                 where project = 'disk-ps-billing'
                   and key_set = 'features'
                   and key = 'mail_pro_b2c_group_disk'),
                cast(null as uuid),
                'user' :: feature_scope
from user_products up
         left join group_products g on up.id = g.user_product_id
where up.code not like '%light%'
  and (g.code isnull or
       (g.code not like '%standard%'
           and g.code not like '%org_mail_pro%v1%'
           and g.code not like '%org_disk_200gb%'
           and g.code not in ('letters_archive', 'org_disk_default_v1')));


--update user_services
update user_services
set status            = 'init',
    updated_at        = now(),
    status_updated_at = now()
where target = 'enabled'
  and id in (select id
             from user_services
             where user_product_id in (select pf.user_product_id
                                       from product_features pf
                                       where pf.code = 'public_settings_enabled'));
