/* pgmigrate-encoding: utf-8 */


CREATE TABLE promo_code_templates
(
    code                  TEXT                                               NOT NULL PRIMARY KEY,
    created_at            TIMESTAMP WITH TIME ZONE DEFAULT current_timestamp NOT NULL,
    updated_at            TIMESTAMP WITH TIME ZONE DEFAULT current_timestamp NOT NULL,
    type                  promo_codes_type                                   NOT NULL,
    user_product_price_id UUID REFERENCES user_product_prices (id) ON DELETE RESTRICT,
    promo_template_id     UUID REFERENCES promo_templates (id) ON DELETE RESTRICT,
    rule_checker_bean_el  TEXT                                               NOT NULL,
    description           TEXT                                               NOT NULL,
    from_date             TIMESTAMP WITH TIME ZONE                           NOT NULL,
    to_date               TIMESTAMP WITH TIME ZONE,
    num_activations       INTEGER                  DEFAULT 1                 NOT NULL,

    CONSTRAINT from_with_to_date_check CHECK (from_date < to_date),
    CONSTRAINT type_contains_rule_check CHECK (
            (type = 'b2b' AND promo_template_id IS NOT NULL AND user_product_price_id IS NULL)
            OR
            (type = 'b2c' AND (promo_template_id IS NULL) != (user_product_price_id IS NULL))
        )
);

COMMENT
ON TABLE promo_code_templates IS 'Шаблоны промо кодов';

COMMENT
ON COLUMN promo_code_templates.code IS 'Код шаблона';
COMMENT
ON COLUMN promo_code_templates.created_at IS 'Дата создания';
COMMENT
ON COLUMN promo_code_templates.updated_at IS 'Дата обновления';
COMMENT
ON COLUMN promo_code_templates.type IS 'Тип шаблона промо кодов';
COMMENT
ON COLUMN promo_code_templates.user_product_price_id IS 'Цена пользовательского продукта';
COMMENT
ON COLUMN promo_code_templates.promo_template_id IS 'Шаблон промо акции';
COMMENT
ON COLUMN promo_code_templates.rule_checker_bean_el IS 'Селектор бин для правил применения';
COMMENT
ON COLUMN promo_code_templates.description IS 'Человекочитаемое описание';
COMMENT
ON COLUMN promo_code_templates.from_date IS 'Дата начала действия промо шаблона';
COMMENT
ON COLUMN promo_code_templates.to_date IS 'Дата окончания действия промо шаблона';
COMMENT
ON COLUMN promo_code_templates.num_activations IS 'Количество возможных активаций';

CREATE INDEX promo_code_templates_user_product_price_id_idx ON promo_code_templates (user_product_price_id);
CREATE INDEX promo_code_templates_promo_template_id_idx ON promo_code_templates (promo_template_id);
