/* pgmigrate-encoding: utf-8 */
create type balance_client_type as enum ('ur', 'ph');

create table balance_payment_infos
(
    id                       UUID DEFAULT uuid_generate_v4()
        CONSTRAINT balance_payment_infos_pk
            PRIMARY KEY,
    client_id                NUMERIC UNIQUE      NOT NULL,
    client_uid               TEXT                NOT NULL,
    created_at               TIMESTAMP           NOT NULL,
    updated_at               TIMESTAMP           NOT NULL,
    client_type              balance_client_type NOT NULL,
    b2b_auto_billing_enabled BOOLEAN             NOT NULL
);

alter table groups
    add balance_payment_info_id uuid;

create index groups_balance_payment_info_id_index
    on groups (balance_payment_info_id);

alter table groups
    add constraint groups_balance_payment_infos_id_fk
        foreign key (balance_payment_info_id) references balance_payment_infos (id) on delete RESTRICT;

