/* pgmigrate-encoding: utf-8 */
-- https://st.yandex-team.ru/DISKBACK-258

-- добавляем новые продукты
select copy_group_product('prepaid_org_mail_pro_optimal1000_trial30_late_april_2022',
                          'prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled_trial30');
select copy_group_product('prepaid_org_mail_pro_advanced3000_trial30_late_april_2022',
                          'prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled_trial30');

-- включаем выключенную фичу
update product_features
set enabled = true
where id in (
    select pf.id
    from group_products g
             join user_products up on g.user_product_id = up.id
             join product_features pf on up.id = pf.user_product_id
    where g.code in ('prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled_trial30',
                     'prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled_trial30')
      and pf.code = 'sso'
);


-- чистим продукты в линейках
delete
from group_products_to_product_lines
where product_line_id in
      (select id
       from product_lines
       where description in
             ('prepaid for b2b 360 late april 2022 (standard trial)',
              'prepaid for b2b 360 late april 2022 (optimal trial)',
              'prepaid for b2b 360 late april 2022 (advanced trial)')
      );



-- (standard trial)
with order_num as (
    select code, order_num
    from (values ('prepaid_org_mail_pro_standard100_trial30_late_april_2022', 1),
                 ('prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled', 2),
                 ('prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled', 3)
         ) s(code, order_num)
)
insert
into group_products_to_product_lines
(product_line_id, group_product_id, order_num)
select (select (select id
                from product_lines
                where description = 'prepaid for b2b 360 late april 2022 (standard trial)')),
       gp.id,
       order_num
from group_products gp
         join order_num o on gp.code = o.code;


-- (optimal trial)
with order_num as (
    select code, order_num
    from (values ('prepaid_org_mail_pro_standard100_late_april_2022', 1),
                 ('prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled_trial30', 2),
                 ('prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled', 3)
         ) s(code, order_num)
)
insert
into group_products_to_product_lines
(product_line_id, group_product_id, order_num)
select (select (select id
                from product_lines
                where description = 'prepaid for b2b 360 late april 2022 (optimal trial)')),
       gp.id,
       order_num
from group_products gp
         join order_num o on gp.code = o.code;


-- (advanced trial)
with order_num as (
    select code, order_num
    from (values ('prepaid_org_mail_pro_standard100_late_april_2022', 1),
                 ('prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled', 2),
                 ('prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled_trial30', 3)
         ) s(code, order_num)
)
insert
into group_products_to_product_lines
(product_line_id, group_product_id, order_num)
select (select (select id
                from product_lines
                where description = 'prepaid for b2b 360 late april 2022 (advanced trial)')),
       gp.id,
       order_num
from group_products gp
         join order_num o on gp.code = o.code;
