/* pgmigrate-encoding: utf-8 */

--fix error_processor_name
update features
set error_processor_name = 'mpfs_with_skip_not_initialized'
where code in ('unlimited_photo_autouploading_allowed', 'unlimited_video_autouploading_allowed');


--enable features
update product_features
set enabled = true
where code in ('unlimited_photo_autouploading_allowed', 'unlimited_video_autouploading_allowed');


--update user_services
update user_services
set status            = 'init',
    updated_at        = now(),
    status_updated_at = now()
where target = 'enabled'
  and id in (select us.id
             from user_services us
                      join product_features pf on pf.user_product_id = us.user_product_id
             where code in ('unlimited_photo_autouploading_allowed',
                            'unlimited_video_autouploading_allowed'));
