/* pgmigrate-encoding: utf-8 */
create or replace function copy_group_product(code_from text, code_to text)
    RETURNS int
    LANGUAGE plpgsql AS
$function$
BEGIN
    perform copy_products(code_from, code_from, code_to);
    insert
    into group_products(code, created_at, updated_at, user_product_id, balance_product_name, price, currency,
                        singleton, skip_transactions_export, trial_definition_id, available_to, hidden,
                        title_tanker_key_id, is_best_offer, payment_type, display_original_price, product_type)
    select code_to,
           now(),
           now(),
           (select id from user_products where code = code_to),
           g.balance_product_name,
           g.price,
           g.currency,
           g.singleton,
           g.skip_transactions_export,
           g.trial_definition_id,
           g.available_to,
           g.hidden,
           g.title_tanker_key_id,
           g.is_best_offer,
           g.payment_type,
           g.display_original_price,
           g.product_type
    from group_products g
    where g.code = code_from;

    -- copy buckets
    insert into bucket_content (bucket_code, group_product_id, updated_at)
    select bc.bucket_code, (select id from group_products where code = code_to), now()
    from bucket_content bc
             join group_products gp on gp.id = bc.group_product_id
    where gp.code = code_from;

    RETURN 0;
END
$function$;

select copy_group_product('prepaid_org_mail_pro_standard100_late_april_2022',
                          'prepaid_org_mail_pro_standard100_late_april_2022_year');

select copy_group_product('prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled',
                          'prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled_year');

select copy_group_product('prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled',
                          'prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled_year');

------------------------------------------------------------------------------------------------------------------------

update group_products
set price = 224
where code = 'prepaid_org_mail_pro_standard100_late_april_2022_year';

update group_products
set price = 444, is_best_offer = true
where code = 'prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled_year';

update group_products
set price = 1119
where code = 'prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled_year';

------------------------------------------------------------------------------------------------------------------------

-- создаём новую линейку с новыми продуктами
with promo_line_id as (
    insert into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
        values ((select id from product_sets where key = 'mail_pro_b2b'),
                now(),
                100,
                'productLineSelectorFactory.compositeAndSelector(' ||
                    'productLineSelectorFactory.prepaidSelector(),' ||
                    'productLineSelectorFactory.experimentIsActiveSelector("b2b_360_exp_1year_tariff")' ||
                ')',
                'prepaid for b2b 360 late april 2022 year')
        returning id),
     order_num as (select code, order_num
                   from (values ('prepaid_org_mail_pro_standard100_late_april_2022_year', 1, false),
                                ('prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled_year', 2, true),
                                ('prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled_year', 3,
                                 false)) s(code, order_num, is_best_offer))
insert
into group_products_to_product_lines
    (product_line_id, group_product_id, order_num, is_best_offer)
    (select promo_line_id.id, gp.id, order_num, is_best_offer
     from promo_line_id,
          group_products gp
              join order_num o on gp.code like o.code);
