/* pgmigrate-encoding: utf-8 */

do
$$
    declare
        new_product_line_id  uuid;
        new_promo_template_id  uuid;
        orig_num_products numeric;
        base_line_description text := 'web default line exp v3';
    begin
        perform backup_catalog('zlarge_product_promocodes_');

        select count(1) into orig_num_products
        from user_products_to_product_lines uptpl
        join product_lines l on l.id = uptpl.product_line_id
        where l.description = base_line_description;

        --before all other promo lines
        perform clone_line(base_line_description, 'large_products_available_promo_line', 100 );
        select id into new_product_line_id
        from product_lines where description = 'large_products_available_promo_line';

        insert into user_products_to_product_lines (product_line_id, user_product_id, order_num)
        values
        (new_product_line_id, (select id from user_products where code = 'mail_pro_b2c_premium5000_v20210610'), 4),
        (new_product_line_id, (select id from user_products where code = 'mail_pro_b2c_premium10000_v20210610'), 5),
        (new_product_line_id, (select id from user_products where code = 'mail_pro_b2c_premium25000_v20210813'), 6),
        (new_product_line_id, (select id from user_products where code = 'mail_pro_b2c_premium50000_v20210813'), 7);

        insert into promo_templates
        (code, description, promo_name_tanker_key_id, from_date, to_date, application_area, application_type, duration,
         duration_measurement, activation_email_template_key, created_at)
        values ('large_products_promocode_promo', 'For promocodes that revive large 5,10,25,50 GB products', null,
                '2022-01-01T00:00:00.000+0300' AT TIME ZONE 'UTC', -- just some past date
                null,
                'per_user'::promo_application_area, 'multiple_time'::promo_application_type,
                14, 'day',
                null,
                now()
               ) returning id into new_promo_template_id;
        perform link_promo('large_products_available_promo_line', 'large_products_promocode_promo');

        perform catalog_diff_with_backup('zlarge_product_promocodes_');

        assert 0 = (select count(1) from zlarge_product_promocodes__new_changed_diff_tanker_keys), 'ass1';
        assert 0 = (select count(1) from zlarge_product_promocodes__new_changed_diff_product_templates), 'ass2';
        assert orig_num_products + 4 = (
            select count(1) from zlarge_product_promocodes__new_changed_diff_user_products_to_pr
            ), 'ass3';
        assert 1 = (select count(1) from zlarge_product_promocodes__new_changed_diff_promo_product_lines), 'ass4';
        assert 0 = (select count(1) from zlarge_product_promocodes__new_changed_diff_promo_payload), 'ass5';
        assert 1 = (select count(1) from zlarge_product_promocodes__new_changed_diff_promo_templates), 'ass6';
        assert 0 = (select count(1) from zlarge_product_promocodes__new_changed_diff_user_products), 'ass7';
        assert 0 = (select count(1) from zlarge_product_promocodes__new_changed_diff_product_features), 'ass8';
        assert 0 = (select count(1) from zlarge_product_promocodes__new_changed_diff_user_product_period), 'ass9';
        assert 0 = (select count(1) from zlarge_product_promocodes__new_changed_diff_user_product_prices), 'ass10';

        --check that new product line contains 7 products: 3 orignal and 4 new ones
        assert orig_num_products + 4 = (
            select count(1)
--             select pl.description, p.code, p.is_best_offer, ppl.*
            from (
                     select *
                     from user_products_to_product_lines
                     except
                     select *
                     from zlarge_product_promocodes_user_products_to_product_lines) ppl
                     left join user_products p on p.id = ppl.user_product_id
                     left join product_lines pl on pl.id = ppl.product_line_id
--             order by product_line_id, order_num
        ), 'ass11';

        --check new product line added with no regard to change of order_num
        assert 1 = (
            select count(1)
            from (
                     select id, product_set_id, created_at, selector_bean_el, description
                     from product_lines
                     except
                     select id, product_set_id, created_at, selector_bean_el, description
                     from zlarge_product_promocodes_product_lines
                 ) diff
        ), 'ass12';

        assert 0 = (select count(1) from zlarge_product_promocodes__absent_diff_tanker_keys), 'ass13';
        assert 0 = (select count(1) from zlarge_product_promocodes__absent_diff_product_templates), 'ass14';
        assert 0 = (select count(1) from zlarge_product_promocodes__absent_diff_user_products_to_product), 'ass15';
        assert 0 = (select count(1) from zlarge_product_promocodes__absent_diff_promo_product_lines), 'ass16';
        assert 0 = (select count(1) from zlarge_product_promocodes__absent_diff_promo_payload), 'ass17';
        assert 0 = (select count(1) from zlarge_product_promocodes__absent_diff_promo_templates), 'ass18';
        assert 0 = (select count(1) from zlarge_product_promocodes__absent_diff_user_products), 'ass19';
        assert 0 = (select count(1) from zlarge_product_promocodes__absent_diff_product_features), 'ass20';
        assert 0 = (select count(1) from zlarge_product_promocodes__absent_diff_user_product_periods), 'ass21';
        assert 0 = (select count(1) from zlarge_product_promocodes__absent_diff_user_product_prices), 'ass22';
    end
$$ LANGUAGE plpgsql;
