/* pgmigrate-encoding: utf-8 */
do
$$
    begin
        insert into balance_payment_infos
        (client_id, client_uid, created_at, updated_at, client_type, b2b_auto_billing_enabled) (
            select DISTINCT on ((payment_info ->> 'client_id')::numeric)
                (payment_info ->> 'client_id')::numeric                                 as client_id,
                payment_info ->> 'uid'                                                  as uid,
                g.updated_at                                                            as created_at,
                g.updated_at                                                            as updated_at,
                coalesce((payment_info ->> 'type'), 'ur')::balance_client_type          as c_type,
                coalesce((payment_info ->> 'b2b_auto_billing_enabled')::boolean, false) as c_auto_billing_enabled
            from groups g
            where payment_info is not null
              and payment_info ->> 'uid' is not null
              and (payment_info ->> 'client_id') is not null
              and payment_info is not null
            order by client_id, updated_at desc)
        on conflict (client_id) do nothing;

        assert not exists(select * from groups g where
                                                       payment_info ->> 'uid' is not null
                                                       and payment_info ->> 'client_id' is not null
                                                       and not exists (
            select * from balance_payment_infos where client_id = (g.payment_info ->> 'client_id')::numeric
            ));

        --code review hotfix
        update balance_payment_infos bpi set b2b_auto_billing_enabled = true
            where exists(select * from groups
                where (payment_info ->> 'client_id')::numeric = bpi.client_id
                and payment_info ->> 'b2b_auto_billing_enabled' = 'true');
        end

$$ LANGUAGE plpgsql;
