/* pgmigrate-encoding: utf-8 */

-- создаем линейки
select create_product_line('mail_pro_b2c',
                           'web promocode line exp v3 only year start discount 30',
                           (select order_num
                            from product_lines
                            where description = 'web promocode line exp v3_megafon_beeline_Getblogger_promocodes'),
                           array ['mail_pro_b2c_premium200_start_discount30_year_only_v20220414_exp3',
                               'mail_pro_b2c_premium1000_start_discount30_year_only_v20220414_exp3',
                               'mail_pro_b2c_premium3000_start_discount30_year_only_v20220414_exp3']);

select create_product_line('mobile_web_pro_b2c',
                           'web promocode line exp v3 only year start discount 30 for mobile',
                           (select order_num
                            from product_lines
                            where description = 'web promocode line exp v3_megafon_beeline_Getblogger_promocodes'),
                           array ['mail_pro_b2c_premium200_start_discount30_year_only_v20220414_exp3',
                               'mail_pro_b2c_premium1000_start_discount30_year_only_v20220414_exp3',
                               'mail_pro_b2c_premium3000_start_discount30_year_only_v20220414_exp3']);

-- создаем промо акции
with promo_data as (select code, promo_name_tanker_key_id, description
                    from (values ('promo_codes_b2c_20_discount_month_year_10_day',
                                  tanker_key_id('disk-ps-billing', 'promos', 'promo_codes_20_discount_month_year'),
                                  'Акция в b2c по промо коду. Скидка старт скидка 20% (месяц / год). Акция доступна 10 дней'),

                                 ('promo_codes_b2c_20_discount_year_10_day',
                                  tanker_key_id('disk-ps-billing', 'promos', 'promo_codes_20_discount_year'),
                                  'Акция в b2c по промо коду. Скидка старт скидка 20% (год). Акция доступна 10 дней'),

                                 ('promo_codes_b2c_30_discount_month_year_10_day',
                                  tanker_key_id('disk-ps-billing', 'promos', 'promo_codes_30_discount_month_year'),
                                  'Акция в b2c по промо коду. Скидка старт скидка 30% (месяц / год). Акция доступна 10 дней')) s(code, promo_name_tanker_key_id, description))
insert
into promo_templates (code,
                      description,
                      promo_name_tanker_key_id,
                      from_date,
                      to_date,
                      application_area,
                      application_type,
                      duration,
                      duration_measurement,
                      activation_email_template_key,
                      created_at)
select pd.code,
       pd.description,
       pd.promo_name_tanker_key_id,
       '2022-01-01T00:00:00.000+0300' AT TIME ZONE 'UTC',
       null,
       'per_user'::promo_application_area,
       'multiple_time'::promo_application_type,
       10,
       'day',
       null,
       now()
from promo_data pd;

-- промо акция 20% месяц/год. Линейки уже подготовлены
select link_promo('web promocode line exp v3_megafon_beeline_Getblogger_promocodes',
                  'promo_codes_b2c_20_discount_month_year_10_day');
select link_promo('web promocode line exp v3 for mobile_megafon_beeline_Getblogger_promocodes',
                  'promo_codes_b2c_20_discount_month_year_10_day');

-- промо акция 20% год
select link_promo('web promocode line exp v3 only year start discount 30 for mobile',
                  'promo_codes_b2c_20_discount_year_10_day');
select link_promo('web promocode line exp v3 only year start discount 30', 'promo_codes_b2c_20_discount_year_10_day');

-- промо акция 30% месяц/год. Линейки уже подготовлены
select link_promo('web promocode line exp v3_mir_promocodes', 'promo_codes_b2c_30_discount_month_year_10_day');
select link_promo('web promocode line exp v3 for mobile_mir_promocodes',
                  'promo_codes_b2c_30_discount_month_year_10_day');
