/* pgmigrate-encoding: utf-8 */

do
$$
    declare
        new_product_line_id  uuid;
        orig_num_products numeric;
        base_line_description text := 'large_products_available_promo_line';
    begin
        alter table user_products_to_product_lines disable trigger delete_product_from_product_line_trigger;

        perform backup_catalog('zlarge_product_prices_');

        select count(1) into orig_num_products
        from user_products_to_product_lines uptpl
                 join product_lines l on l.id = uptpl.product_line_id
        where l.description = base_line_description;

        select id into new_product_line_id
        from product_lines where description = base_line_description;

        delete from user_products_to_product_lines
        where product_line_id = new_product_line_id
          and user_product_id in (
              select id from user_products where code in (
                  'mail_pro_b2c_premium5000_v20210610',
                  'mail_pro_b2c_premium10000_v20210610',
                  'mail_pro_b2c_premium25000_v20210813',
                  'mail_pro_b2c_premium50000_v20210813'
                  )
            );

        perform copy_products(
            'mail_pro_b2c_premium5000_v20210610',
            'mail_pro_b2c_premium5000_v20210610',
            'mail_pro_b2c_premium5000_v20220721');
        perform copy_products(
            'mail_pro_b2c_premium10000_v20210610',
            'mail_pro_b2c_premium10000_v20210610',
            'mail_pro_b2c_premium10000_v20220721');
        perform copy_products(
            'mail_pro_b2c_premium25000_v20210813',
            'mail_pro_b2c_premium25000_v20210813',
            'mail_pro_b2c_premium25000_v20220721');
        perform copy_products(
            'mail_pro_b2c_premium50000_v20210813',
            'mail_pro_b2c_premium50000_v20210813',
            'mail_pro_b2c_premium50000_v20220721');

        insert into user_products_to_product_lines (product_line_id, user_product_id, order_num)
        values
            (new_product_line_id, (select id from user_products where code = 'mail_pro_b2c_premium5000_v20220721'), 4),
            (new_product_line_id, (select id from user_products where code = 'mail_pro_b2c_premium10000_v20220721'), 5),
            (new_product_line_id, (select id from user_products where code = 'mail_pro_b2c_premium25000_v20220721'), 6),
            (new_product_line_id, (select id from user_products where code = 'mail_pro_b2c_premium50000_v20220721'), 7);


        perform change_price('mail_pro_b2c_premium5000_v20220721', 'month', 1332, null, null, 'RUB');
        perform change_price('mail_pro_b2c_premium10000_v20220721', 'month', 2664, null, null, 'RUB');
        perform change_price('mail_pro_b2c_premium25000_v20220721', 'month', 6659, null, null, 'RUB');
        perform change_price('mail_pro_b2c_premium50000_v20220721', 'month', 13317, null, null, 'RUB');

        perform change_price('mail_pro_b2c_premium5000_v20220721', 'year', 9484, null, null, 'RUB');
        perform change_price('mail_pro_b2c_premium10000_v20220721', 'year', 18967, null, null, 'RUB');
        perform change_price('mail_pro_b2c_premium25000_v20220721', 'year', 47417, null, null, 'RUB');
        perform change_price('mail_pro_b2c_premium50000_v20220721', 'year', 94834, null, null, 'RUB');

        perform change_price('mail_pro_b2c_premium5000_v20220721', 'month', 16.65, null, null, 'USD');
        perform change_price('mail_pro_b2c_premium10000_v20220721', 'month', 33.3, null, null, 'USD');
        perform change_price('mail_pro_b2c_premium25000_v20220721', 'month', 83.25, null, null, 'USD');
        perform change_price('mail_pro_b2c_premium50000_v20220721', 'month', 166.5, null, null, 'USD');

        perform change_price('mail_pro_b2c_premium5000_v20220721', 'year', 119.98, null, null, 'USD');
        perform change_price('mail_pro_b2c_premium10000_v20220721', 'year', 239.97, null, null, 'USD');
        perform change_price('mail_pro_b2c_premium25000_v20220721', 'year', 599.92, null, null, 'USD');
        perform change_price('mail_pro_b2c_premium50000_v20220721', 'year', 1199.83, null, null, 'USD');

        perform catalog_diff_with_backup('zlarge_product_prices_');

        assert 0 = (select count(1) from zlarge_product_prices__new_changed_diff_tanker_keys), 'ass1';
        assert 0 = (select count(1) from zlarge_product_prices__new_changed_diff_product_templates), 'ass2';
        assert 0 = (select count(1) from zlarge_product_prices__new_changed_diff_product_lines), 'ass2.2';
        assert 4 = (
            select count(1) from zlarge_product_prices__new_changed_diff_user_products_to_produc
        ), 'ass3';
        assert 0 = (select count(1) from zlarge_product_prices__new_changed_diff_promo_product_lines), 'ass4';
        assert 0 = (select count(1) from zlarge_product_prices__new_changed_diff_promo_payload), 'ass5';
        assert 0 = (select count(1) from zlarge_product_prices__new_changed_diff_promo_templates), 'ass6';
        assert 4 = (select count(1) from zlarge_product_prices__new_changed_diff_user_products), 'ass7';
--         assert 76 = (select count(1) from zlarge_product_prices__new_changed_diff_product_features), 'ass8';
        assert 8 = (select count(1) from zlarge_product_prices__new_changed_diff_user_product_periods), 'ass9';
        assert 16 = (select count(1) from zlarge_product_prices__new_changed_diff_user_product_prices), 'ass10';

        assert 0 = (select count(1) from zlarge_product_prices__absent_diff_tanker_keys), 'ass13';
        assert 0 = (select count(1) from zlarge_product_prices__absent_diff_product_templates), 'ass14';
        assert 4 = (select count(1) from zlarge_product_prices__absent_diff_user_products_to_product_lin), 'ass152';
        assert 0 = (select count(1) from zlarge_product_prices__absent_diff_promo_product_lines), 'ass16';
        assert 0 = (select count(1) from zlarge_product_prices__absent_diff_promo_payload), 'ass17';
        assert 0 = (select count(1) from zlarge_product_prices__absent_diff_promo_templates), 'ass18';
        assert 0 = (select count(1) from zlarge_product_prices__absent_diff_user_products), 'ass19';
        assert 0 = (select count(1) from zlarge_product_prices__absent_diff_product_features), 'ass20';
        assert 0 = (select count(1) from zlarge_product_prices__absent_diff_user_product_periods), 'ass21';
        assert 0 = (select count(1) from zlarge_product_prices__absent_diff_user_product_prices), 'ass22';

        alter table user_products_to_product_lines disable trigger delete_product_from_product_line_trigger;
    end
$$ LANGUAGE plpgsql;

