/* pgmigrate-encoding: utf-8 */

with subquery as (select distinct pl.id as plid, pl.selector_bean_el
                  from product_lines pl
                           join user_products_to_product_lines uppl on uppl.product_line_id = pl.id
                           join user_products up on up.id = uppl.user_product_id
                           join user_product_periods upp on upp.user_product_id = up.id
                  where pl.product_set_id = (select id from product_sets ps where ps.key = 'mobile_web_pro_b2c')
                    and upp.start_period_count is not null)
update product_lines
set selector_bean_el = 'productLineSelectorFactory.missingConflictUserProductInLineSelector(' || subquery.selector_bean_el || ')'
    FROM subquery
WHERE product_lines.id = subquery.plid;
