/* pgmigrate-encoding: utf-8 */

select *
from copy_products('mail_pro_b2c_premium200_start_discount30_year_only_v20220414_exp3',
                   'mail_pro_b2c_premium200_start_discount30_year_only_v20220414_exp3',
                   'mail_pro_b2c_premium200_start_discount20_year_only_v20220414_exp3');

select *
from copy_products('mail_pro_b2c_premium1000_start_discount30_year_only_v20220414_exp3',
                   'mail_pro_b2c_premium1000_start_discount30_year_only_v20220414_exp3',
                   'mail_pro_b2c_premium1000_start_discount20_year_only_v20220414_exp3');

select *
from copy_products('mail_pro_b2c_premium3000_start_discount30_year_only_v20220414_exp3',
                   'mail_pro_b2c_premium3000_start_discount30_year_only_v20220414_exp3',
                   'mail_pro_b2c_premium3000_start_discount20_year_only_v20220414_exp3');

select *
from change_start_price('mail_pro_b2c_premium200_start_discount20_year_only_v20220414_exp3', 'year', 1032, 'RUB');
select *
from change_start_price('mail_pro_b2c_premium1000_start_discount20_year_only_v20220414_exp3', 'year', 1832, 'RUB');
select *
from change_start_price('mail_pro_b2c_premium3000_start_discount20_year_only_v20220414_exp3', 'year', 4552, 'RUB');

select *
from change_start_price('mail_pro_b2c_premium200_start_discount20_year_only_v20220414_exp3', 'year', 13.19, 'USD');
select *
from change_start_price('mail_pro_b2c_premium1000_start_discount20_year_only_v20220414_exp3', 'year', 23.19, 'USD');
select *
from change_start_price('mail_pro_b2c_premium3000_start_discount20_year_only_v20220414_exp3', 'year', 57.59, 'USD');

-- создаем линейки
select create_product_line('mail_pro_b2c',
                           'web promocode line exp v3 only year start discount 20',
                           (select order_num
                            from product_lines
                            where description = 'web promocode line exp v3_megafon_beeline_Getblogger_promocodes'),
                           array ['mail_pro_b2c_premium200_start_discount20_year_only_v20220414_exp3',
                               'mail_pro_b2c_premium1000_start_discount20_year_only_v20220414_exp3',
                               'mail_pro_b2c_premium3000_start_discount20_year_only_v20220414_exp3']);

select create_product_line('mobile_web_pro_b2c',
                           'web promocode line exp v3 only year start discount 20 for mobile',
                           (select order_num
                            from product_lines
                            where description = 'web promocode line exp v3_megafon_beeline_Getblogger_promocodes'),
                           array ['mail_pro_b2c_premium200_start_discount20_year_only_v20220414_exp3',
                               'mail_pro_b2c_premium1000_start_discount20_year_only_v20220414_exp3',
                               'mail_pro_b2c_premium3000_start_discount20_year_only_v20220414_exp3']);
do
$$
    declare
        affected numeric;
    BEGIN

        delete
        from promo_product_lines
        where promo_template_id =
              (select id from promo_templates where code = 'promo_codes_b2c_20_discount_year_10_day')
          and product_line_id in (select id
                                  from product_lines
                                  where description in
                                        ('web promocode line exp v3 only year start discount 30 for mobile',
                                         'web promocode line exp v3 only year start discount 30'));

        GET DIAGNOSTICS affected = ROW_COUNT;
        assert affected = 2;

        assert 0 = (select count(1)
                    from promo_product_lines
                    where promo_template_id =
                          (select id from promo_templates where code = 'promo_codes_b2c_20_discount_year_10_day'));

    end

$$ LANGUAGE plpgsql;

-- промо акция 20% год
select link_promo('web promocode line exp v3 only year start discount 20 for mobile',
                  'promo_codes_b2c_20_discount_year_10_day');
select link_promo('web promocode line exp v3 only year start discount 20', 'promo_codes_b2c_20_discount_year_10_day');
