/* pgmigrate-encoding: utf-8 */

-- продукты со скидкой 30% на первые 3 месяца
select copy_group_product('prepaid_org_mail_pro_standard100_late_april_2022',
                          'prepaid_org_mail_pro_standard100_late_april_2022_discount30_first_3_months');

select copy_group_product('prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled',
                          'prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled_discount30_first_3_months');

select copy_group_product('prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled',
                          'prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled_discount30_first_3_months');

-- продукт со скидкой 20% на первые 3 месяца
select copy_group_product('prepaid_org_mail_pro_standard100_late_april_2022',
                          'prepaid_org_mail_pro_standard100_late_april_2022_discount20_first_3_months');

select copy_group_product('prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled',
                          'prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled_discount20_first_3_months');

select copy_group_product('prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled',
                          'prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled_discount20_first_3_months');

-- продукт со скидкой 15% на первые 3 месяца
select copy_group_product('prepaid_org_mail_pro_standard100_late_april_2022',
                          'prepaid_org_mail_pro_standard100_late_april_2022_discount15_first_3_months');

select copy_group_product('prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled',
                          'prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled_discount15_first_3_months');

select copy_group_product('prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled',
                          'prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled_discount15_first_3_months');

-- годовые продукты со скидкой 30%
select copy_group_product('prepaid_org_mail_pro_standard100_late_april_2022_year',
                          'prepaid_org_mail_pro_standard100_late_april_2022_discount30_year');

select copy_group_product('prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled_year',
                          'prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled_discount30_year');

select copy_group_product('prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled_year',
                          'prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled_discount30_year');

-- годовые продукты со скидкой 20%
select copy_group_product('prepaid_org_mail_pro_standard100_late_april_2022_year',
                          'prepaid_org_mail_pro_standard100_late_april_2022_discount20_year');

------------------------------------------------------------------------------------------------------------------------
do
$$
    declare
        affected numeric;
    BEGIN

        -- trial definitions на 3 месяца - скидка 30% (174)
        with trial_def as (
            insert
                into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden,
                                        single_usage_comparison_key)
                    values (now(), 'constant_period', null, 3, 'month', 174, false, 'todo_remove')
                    returning *)
        update group_products
        set trial_definition_id    = (select id from trial_def),
            display_original_price = 249,
            price                  = 249,
            is_best_offer          = false
        where code = 'prepaid_org_mail_pro_standard100_late_april_2022_discount30_first_3_months';

        GET DIAGNOSTICS affected = ROW_COUNT;
        assert affected = 1;

        -- trial definitions на 3 месяца - скидка 30% (389)
        with trial_def as (
            insert
                into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden,
                                        single_usage_comparison_key)
                    values (now(), 'constant_period', null, 3, 'month', 389, false, 'todo_remove')
                    returning *)
        update group_products
        set trial_definition_id    = (select id from trial_def),
            display_original_price = 559,
            price                  = 559,
            is_best_offer          = true
        where code = 'prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled_discount30_first_3_months';

        GET DIAGNOSTICS affected = ROW_COUNT;
        assert affected = 1;

        -- trial definitions на 3 месяца - скидка 30% (979)
        with trial_def as (
            insert
                into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden,
                                        single_usage_comparison_key)
                    values (now(), 'constant_period', null, 3, 'month', 979, false, 'todo_remove')
                    returning *)
        update group_products
        set trial_definition_id    = (select id from trial_def),
            display_original_price = 1399,
            price                  = 1399,
            is_best_offer          = false
        where code = 'prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled_discount30_first_3_months';

        GET DIAGNOSTICS affected = ROW_COUNT;
        assert affected = 1;

        -- trial definitions на 3 месяца - скидка 20% (199)
        with trial_def as (
            insert
                into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden,
                                        single_usage_comparison_key)
                    values (now(), 'constant_period', null, 3, 'month', 199, false, 'todo_remove')
                    returning *)
        update group_products
        set trial_definition_id    = (select id from trial_def),
            display_original_price = 249,
            price                  = 249,
            is_best_offer          = false
        where code = 'prepaid_org_mail_pro_standard100_late_april_2022_discount20_first_3_months';

        GET DIAGNOSTICS affected = ROW_COUNT;
        assert affected = 1;

        -- trial definitions на 3 месяца - скидка 20% (444)
        with trial_def as (
            insert
                into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden,
                                        single_usage_comparison_key)
                    values (now(), 'constant_period', null, 3, 'month', 444, false, 'todo_remove')
                    returning *)
        update group_products
        set trial_definition_id    = (select id from trial_def),
            display_original_price = 559,
            price                  = 559,
            is_best_offer          = true
        where code = 'prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled_discount20_first_3_months';

        GET DIAGNOSTICS affected = ROW_COUNT;
        assert affected = 1;

        -- trial definitions на 3 месяца - скидка 20% (1119)
        with trial_def as (
            insert
                into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden,
                                        single_usage_comparison_key)
                    values (now(), 'constant_period', null, 3, 'month', 1119, false, 'todo_remove')
                    returning *)
        update group_products
        set trial_definition_id    = (select id from trial_def),
            display_original_price = 1399,
            price                  = 1399,
            is_best_offer          = false
        where code = 'prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled_discount20_first_3_months';

        GET DIAGNOSTICS affected = ROW_COUNT;
        assert affected = 1;

        -- trial definitions на 3 месяца - скидка 15% (211)
        with trial_def as (
            insert
                into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden,
                                        single_usage_comparison_key)
                    values (now(), 'constant_period', null, 3, 'month', 211, false, 'todo_remove')
                    returning *)
        update group_products
        set trial_definition_id    = (select id from trial_def),
            display_original_price = 249,
            price                  = 249,
            is_best_offer          = false
        where code = 'prepaid_org_mail_pro_standard100_late_april_2022_discount15_first_3_months';

        GET DIAGNOSTICS affected = ROW_COUNT;
        assert affected = 1;

        -- trial definitions на 3 месяца - скидка 15% (469)
        with trial_def as (
            insert
                into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden,
                                        single_usage_comparison_key)
                    values (now(), 'constant_period', null, 3, 'month', 469, false, 'todo_remove')
                    returning *)
        update group_products
        set trial_definition_id    = (select id from trial_def),
            display_original_price = 559,
            price                  = 559,
            is_best_offer          = true
        where code = 'prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled_discount15_first_3_months';

        GET DIAGNOSTICS affected = ROW_COUNT;
        assert affected = 1;

        -- trial definitions на 3 месяца - скидка 15% (1189)
        with trial_def as (
            insert
                into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden,
                                        single_usage_comparison_key)
                    values (now(), 'constant_period', null, 3, 'month', 1189, false, 'todo_remove')
                    returning *)
        update group_products
        set trial_definition_id    = (select id from trial_def),
            display_original_price = 1399,
            price                  = 1399,
            is_best_offer          = false
        where code = 'prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled_discount15_first_3_months';

        GET DIAGNOSTICS affected = ROW_COUNT;
        assert affected = 1;
        -----------------------------------------------------------------------------------------------------------------------

        -- годовые 30%
        with trial_def as (
            insert
                into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden,
                                        single_usage_comparison_key)
                    values (now(), 'constant_period', null, 1, 'year', 174, false, 'todo_remove')
                    returning *)
        update group_products
        set trial_definition_id    = (select id from trial_def),
            display_original_price = 224,
            price                  = 224
        where code = 'prepaid_org_mail_pro_standard100_late_april_2022_discount30_year';

        GET DIAGNOSTICS affected = ROW_COUNT;
        assert affected = 1;

        with trial_def as (
            insert
                into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden,
                                        single_usage_comparison_key)
                    values (now(), 'constant_period', null, 1, 'year', 389, false, 'todo_remove')
                    returning *)
        update group_products
        set trial_definition_id    = (select id from trial_def),
            is_best_offer          = true,
            display_original_price = 444,
            price                  = 444
        where code = 'prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled_discount30_year';

        GET DIAGNOSTICS affected = ROW_COUNT;
        assert affected = 1;

        with trial_def as (
            insert
                into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden,
                                        single_usage_comparison_key)
                    values (now(), 'constant_period', null, 1, 'year', 979, false, 'todo_remove')
                    returning *)
        update group_products
        set trial_definition_id    = (select id from trial_def),
            display_original_price = 1119,
            price                  = 1119
        where code = 'prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled_discount30_year';

        GET DIAGNOSTICS affected = ROW_COUNT;
        assert affected = 1;


        -- годовые 20% (только стандарт)
        with trial_def as (
            insert
                into trial_definitions (created_at, type, end_date, duration, duration_measurement, price, hidden,
                                        single_usage_comparison_key)
                    values (now(), 'constant_period', null, 1, 'year', 199, false, 'todo_remove')
                    returning *)
        update group_products
        set trial_definition_id    = (select id from trial_def),
            display_original_price = 224,
            price                  = 224
        where code = 'prepaid_org_mail_pro_standard100_late_april_2022_discount20_year';

        GET DIAGNOSTICS affected = ROW_COUNT;
        assert affected = 1;
    END
$$;
------------------------------------------------------------------------------------------------------------------------


-- создаём новую линейку с новыми продуктами (discount 30 - 3 months)
with product_line_id as (
    insert
        into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
            values ((select id from product_sets where key = 'mail_pro_b2b'),
                    now(),
                    10501,
                    'productLineSelectorFactory.prepaidSelector()',
                    'prepaid for b2b 360 late april 2022 (all discount 30 - 3 months)')
            returning id),
     order_num as (select code, order_num
                   from (values ('prepaid_org_mail_pro_standard100_late_april_2022_discount30_first_3_months', 1,
                                 false),
                                ('prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled_discount30_first_3_months',
                                 2, true),
                                ('prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled_discount30_first_3_months',
                                 3, false)) s(code, order_num, is_best_offer))
insert
into group_products_to_product_lines
    (product_line_id, group_product_id, order_num, is_best_offer)
    (select product_line_id.id, gp.id, order_num, is_best_offer
     from product_line_id,
          group_products gp
              join order_num o on gp.code like o.code);

-- создаём новую линейку с новыми продуктами (discount 20 - 3 months)
with product_line_id as (
    insert
        into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
            values ((select id from product_sets where key = 'mail_pro_b2b'),
                    now(),
                    10502,
                    'productLineSelectorFactory.prepaidSelector()',
                    'prepaid for b2b 360 late april 2022 (all discount 20 - 3 months)')
            returning id),
     order_num as (select code, order_num
                   from (values ('prepaid_org_mail_pro_standard100_late_april_2022_discount20_first_3_months', 1,
                                 false),
                                ('prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled_discount20_first_3_months',
                                 2, true),
                                ('prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled_discount20_first_3_months',
                                 3, false)) s(code, order_num, is_best_offer))
insert
into group_products_to_product_lines
    (product_line_id, group_product_id, order_num, is_best_offer)
    (select product_line_id.id, gp.id, order_num, is_best_offer
     from product_line_id,
          group_products gp
              join order_num o on gp.code like o.code);

-- создаём новую линейку с новыми продуктами (discount 15 - 3 months)
with product_line_id as (
    insert
        into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
            values ((select id from product_sets where key = 'mail_pro_b2b'),
                    now(),
                    10503,
                    'productLineSelectorFactory.prepaidSelector()',
                    'prepaid for b2b 360 late april 2022 (all discount 15 - 3 months)')
            returning id),
     order_num as (select code, order_num
                   from (values ('prepaid_org_mail_pro_standard100_late_april_2022_discount15_first_3_months', 1,
                                 false),
                                ('prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled_discount15_first_3_months',
                                 2, true),
                                ('prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled_discount15_first_3_months',
                                 3, false)) s(code, order_num, is_best_offer))
insert
into group_products_to_product_lines
    (product_line_id, group_product_id, order_num, is_best_offer)
    (select product_line_id.id, gp.id, order_num, is_best_offer
     from product_line_id,
          group_products gp
              join order_num o on gp.code like o.code);

-- годовые 30%
with product_line_id as (
    insert
        into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
            values ((select id from product_sets where key = 'mail_pro_b2b'),
                    now(),
                    10102,
                    'productLineSelectorFactory.compositeAndSelector(' ||
                    'productLineSelectorFactory.prepaidSelector(),' ||
                    'productLineSelectorFactory.experimentIsActiveSelector("b2b_360_exp_1year_tariff")' ||
                    ')',
                    'prepaid for b2b 360 late april 2022 (all discount 30 - 1 year) year')
            returning id),
     order_num as (select code, order_num
                   from (values ('prepaid_org_mail_pro_standard100_late_april_2022_discount30_year', 1, false),
                                ('prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled_discount30_year', 2,
                                 true),
                                ('prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled_discount30_year', 3,
                                 false)) s(code, order_num, is_best_offer))
insert
into group_products_to_product_lines
    (product_line_id, group_product_id, order_num, is_best_offer)
    (select product_line_id.id, gp.id, order_num, is_best_offer
     from product_line_id,
          group_products gp
              join order_num o on gp.code like o.code);

-- годовые 20% (только стандарт)
with product_line_id as (
    insert
        into product_lines (product_set_id, created_at, order_num, selector_bean_el, description)
            values ((select id from product_sets where key = 'mail_pro_b2b'),
                    now(),
                    10103,
                    'productLineSelectorFactory.compositeAndSelector(' ||
                    'productLineSelectorFactory.prepaidSelector(),' ||
                    'productLineSelectorFactory.experimentIsActiveSelector("b2b_360_exp_1year_tariff")' ||
                    ')',
                    'prepaid for b2b 360 late april 2022 (standard discount 20 - 1 year) year')
            returning id),
     order_num as (select code, order_num
                   from (values ('prepaid_org_mail_pro_standard100_late_april_2022_discount20_year', 1, false),
                                ('prepaid_org_mail_pro_optimal1000_late_april_2022_sso_enabled_year', 2, true),
                                ('prepaid_org_mail_pro_advanced3000_late_april_2022_sso_enabled_year', 3,
                                 false)) s(code, order_num, is_best_offer))
insert
into group_products_to_product_lines
    (product_line_id, group_product_id, order_num, is_best_offer)
    (select product_line_id.id, gp.id, order_num, is_best_offer
     from product_line_id,
          group_products gp
              join order_num o on gp.code like o.code);

------------------------------------------------------------------------------------------------------------------------
with promo_data as (select code, description, tanker_id
                    from (values ('b2b_promo_code_30_month_year_all',
                                  'Акция в b2b по промо коду. Скидка 30% (месяц / год)',
                                  tanker_key_id('disk-ps-billing', 'promos-', 'b2b_promo_code_30_month_year_all')),
                                 ('b2b_promo_code_20_month_year_all',
                                  'Акция в b2b по промо коду. Скидка 20% (месяц / год)',
                                  tanker_key_id('disk-ps-billing', 'promos', 'b2b_promo_code_20_month_year_all')),
                                 ('b2b_promo_code_15_month_all_20_year_standard',
                                  'Акция в b2b по промо коду. Скидка 15% месяц / 20% год',
                                  tanker_key_id('disk-ps-billing', 'promos',
                                                'b2b_promo_code_15_month_all_20_year_standard'))) s(code, description, tanker_id))
insert
into promo_templates (code,
                      description,
                      promo_name_tanker_key_id,
                      from_date,
                      to_date,
                      application_area,
                      application_type,
                      duration,
                      duration_measurement,
                      activation_email_template_key,
                      created_at)
select pd.code,
       pd.description,
       pd.tanker_id,
       '2022-01-01T00:00:00.000+0300' AT TIME ZONE 'UTC',
       null,
       'per_group'::promo_application_area,
       'multiple_time'::promo_application_type,
       14,
       'day',
       null,
       now()
from promo_data pd;

-- 30%
select link_promo('prepaid for b2b 360 late april 2022 (all discount 30 - 3 months)',
                  'b2b_promo_code_30_month_year_all');
select link_promo('prepaid for b2b 360 late april 2022 (all discount 30 - 1 year) year',
                  'b2b_promo_code_30_month_year_all');

-- 20%
select link_promo('prepaid for b2b 360 late april 2022 (all discount 20 - 3 months)',
                  'b2b_promo_code_20_month_year_all');
select link_promo('prepaid for b2b 360 late april 2022 (all discount 30 - 1 year) year',
                  'b2b_promo_code_20_month_year_all');

-- 15% / 20%
select link_promo('prepaid for b2b 360 late april 2022 (all discount 15 - 3 months)',
                  'b2b_promo_code_15_month_all_20_year_standard');
select link_promo('prepaid for b2b 360 late april 2022 (standard discount 20 - 1 year) year',
                  'b2b_promo_code_15_month_all_20_year_standard');
