/* pgmigrate-encoding: utf-8 */
do
$$
    begin
        insert into promo_product_lines (promo_template_id, product_line_id)
        select ppl.promo_template_id, mobile.id
        from (SELECT id, REPLACE(description, ' for mobile', '') as description
              FROM product_lines
                       left join promo_product_lines ppl on product_lines.id = ppl.product_line_id
              where 1 = 1
                and product_set_id = (select id from product_sets where key = 'mobile_web_pro_b2c')
                and promo_template_id is null) mobile
                 join product_lines web on web.description = mobile.description
                 join promo_product_lines ppl on web.id = ppl.product_line_id;

        assert not exists(
            SELECT *
            FROM product_lines pl
                     join promo_product_lines ppl on pl.id = ppl.product_line_id
                     join product_lines mpl on pl.description = REPLACE(mpl.description, ' for mobile', '')
                     left join promo_product_lines mppl on mpl.id = mppl.product_line_id
            where 1 = 1
              and pl.product_set_id = (select id from product_sets where key = 'mail_pro_b2c') and mppl is null
            );
    end
$$ LANGUAGE plpgsql;
