CREATE OR REPLACE FUNCTION code.add_husky(
    i_host                  text,
    i_allow_duplicate_hosts boolean = false
)  RETURNS integer as $$
DECLARE
    ret_husky_id integer;
BEGIN
    INSERT INTO transfer.huskies
    SELECT
        nextval('transfer.huskies_s'), i_host
    WHERE NOT i_allow_duplicate_hosts
      AND NOT EXISTS (
        SELECT 1
          FROM transfer.huskies
         WHERE host=i_host)
    RETURNING husky_id INTO ret_husky_id;

    IF NOT found THEN
        RAISE NOTICE 'Husky at given host is already registered.';

        SELECT husky_id
          INTO ret_husky_id
          FROM transfer.huskies
         WHERE host=i_host;
    END IF;

    RETURN ret_husky_id;
END;
$$ LANGUAGE plpgsql;

