CREATE OR REPLACE FUNCTION code.add_shard(
    i_shard_name text,
    i_host text,
    i_port integer,
    i_dc text,
    i_dbname text
)  RETURNS integer as $$
DECLARE
    l_shard_id integer;
BEGIN
    INSERT INTO shards.shards
    SELECT
        (nextval('shards.shard_s')),
        i_shard_name
    WHERE NOT EXISTS (
        SELECT 1
          FROM shards.instances
         WHERE  host=i_host)
    RETURNING shard_id INTO l_shard_id;

    IF found THEN
        INSERT INTO shards.instances
            (instance_id,
            shard_id,
            host,
            port,
            dc,
            dbname)
        VALUES
            (nextval('shards.instance_s'),
            l_shard_id,
            i_host,
            i_port,
            i_dc,
            i_dbname);

    ELSE
        RAISE NOTICE 'Shard already exists.';

        SELECT shard_id
          INTO l_shard_id
          FROM shards.instances
         WHERE  host=i_host;
    END IF;

    RETURN l_shard_id;
END;
$$ LANGUAGE plpgsql;
