CREATE OR REPLACE FUNCTION code.create_user(
    i_uid bigint,
    i_shard_id integer
) RETURNS code.create_user_result AS $$
DECLARE
BEGIN
    INSERT INTO shards.users (uid, shard_id)
    VALUES (i_uid, i_shard_id);

    RETURN 'success';
EXCEPTION
    WHEN unique_violation THEN
        RETURN 'already_registered';
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION code.create_user(
    i_uid text,
    i_shard_id integer
) RETURNS code.create_user_result AS $$
DECLARE
BEGIN
    BEGIN
        RETURN code.create_user(i_uid::bigint, i_shard_id);
    EXCEPTION
        WHEN invalid_text_representation THEN
    END;

    INSERT INTO shards.text_users (uid, shard_id)
    VALUES (i_uid, i_shard_id);

    RETURN 'success';
EXCEPTION
    WHEN unique_violation THEN
        RETURN 'already_registered';
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION code.create_user_2(
    i_uid bigint,
    i_shard_id integer
) RETURNS integer AS $$
DECLARE
    inserted integer;
    real_shard_id integer;
BEGIN
    INSERT INTO shards.users (uid, shard_id)
    VALUES (i_uid, i_shard_id)
    ON CONFLICT DO NOTHING
    RETURNING shard_id INTO real_shard_id;

    GET DIAGNOSTICS inserted = ROW_COUNT;

    IF inserted = 0 THEN
        SELECT shard_id
          FROM shards.users
         WHERE uid = i_uid
          INTO real_shard_id;
    END IF;

    RETURN real_shard_id;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION code.create_user_2(
    i_uid text,
    i_shard_id integer
) RETURNS integer AS $$
DECLARE
    inserted integer;
    real_shard_id integer;
BEGIN
    BEGIN
        RETURN code.create_user_2(i_uid::bigint, i_shard_id);
    EXCEPTION
        WHEN invalid_text_representation THEN
    END;

    INSERT INTO shards.text_users (uid, shard_id)
    VALUES (i_uid, i_shard_id)
    ON CONFLICT DO NOTHING
    RETURNING shard_id INTO real_shard_id;

    GET DIAGNOSTICS inserted = ROW_COUNT;

    IF inserted = 0 THEN
        SELECT shard_id
          FROM shards.text_users
         WHERE uid = i_uid
          INTO real_shard_id;
    END IF;

    RETURN real_shard_id;
END;
$$ LANGUAGE plpgsql;
