CREATE OR REPLACE FUNCTION code.make_transfer_args(
    i_from_db text,
    i_to_db   text,
    i_disallow_inited       boolean = false,
    i_fill_change_log       boolean = false,
    i_update_mail_migration boolean = false
) RETURNS jsonb AS $$
    SELECT json_build_object(
               'disallow_inited', i_disallow_inited,
               'fill_change_log', i_fill_change_log,
               'update_mail_migration', i_update_mail_migration,
               'from_db', i_from_db,
               'to_db', i_to_db
           )::jsonb;
$$ LANGUAGE SQL IMMUTABLE;
