CREATE OR REPLACE FUNCTION code.update_user(
    i_uid bigint,
    i_data jsonb
) RETURNS code.update_user_result AS $$
BEGIN
    UPDATE shards.users
       SET data = i_data
     WHERE uid = i_uid;

    IF NOT FOUND THEN
        RETURN 'user_not_found';
    END IF;

    RETURN 'success';
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION code.update_user(
    i_uid text,
    i_data jsonb
) RETURNS code.update_user_result AS $$
BEGIN
    BEGIN
        RETURN code.update_user(i_uid::bigint, i_data);
    EXCEPTION
        WHEN invalid_text_representation THEN
    END;

    UPDATE shards.text_users
       SET data = i_data
     WHERE uid = i_uid;

    IF NOT FOUND THEN
        RETURN 'user_not_found';
    END IF;

    RETURN 'success';
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION code.update_user(
    i_uid bigint,
    i_shard_id bigint,
    i_data jsonb
) RETURNS code.update_user_result AS $$
BEGIN
    IF NOT EXISTS(
        SELECT uid
          FROM shards.users
         WHERE uid = i_uid
           FOR UPDATE
    ) THEN
        RETURN 'user_not_found';
    END IF;

    UPDATE shards.users
       SET data = i_data
     WHERE uid = i_uid
       AND shard_id = i_shard_id;

    IF NOT FOUND THEN
        RETURN 'invalid_user_shard_id';
    END IF;

    RETURN 'success';
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION code.update_user(
    i_uid text,
    i_shard_id bigint,
    i_data jsonb
) RETURNS code.update_user_result AS $$
BEGIN
    BEGIN
        RETURN code.update_user(i_uid::bigint, i_shard_id, i_data);
    EXCEPTION
        WHEN invalid_text_representation THEN
    END;

    IF NOT EXISTS(
        SELECT uid
          FROM shards.text_users
         WHERE uid = i_uid
           FOR UPDATE
    ) THEN
        RETURN 'user_not_found';
    END IF;

    UPDATE shards.text_users
       SET data = i_data
     WHERE uid = i_uid
       AND shard_id = i_shard_id;

    IF NOT FOUND THEN
        RETURN 'invalid_user_shard_id';
    END IF;

    RETURN 'success';
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION code.update_user(
    i_uid bigint,
    i_shard_id bigint,
    i_new_shard_id bigint
) RETURNS code.update_user_result AS $$
BEGIN
    IF NOT EXISTS(
        SELECT uid
          FROM shards.users
         WHERE uid = i_uid
           FOR UPDATE
    ) THEN
        RETURN 'user_not_found';
    END IF;

    UPDATE shards.users
       SET shard_id = i_new_shard_id
     WHERE uid = i_uid
       AND shard_id = i_shard_id;

    IF NOT FOUND THEN
        RETURN 'invalid_user_shard_id';
    END IF;

    RETURN 'success';
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION code.update_user(
    i_uid text,
    i_shard_id bigint,
    i_new_shard_id bigint
) RETURNS code.update_user_result AS $$
BEGIN
    BEGIN
        RETURN code.update_user(i_uid::bigint, i_shard_id, i_new_shard_id);
    EXCEPTION
        WHEN invalid_text_representation THEN
    END;

    IF NOT EXISTS(
        SELECT uid
          FROM shards.text_users
         WHERE uid = i_uid
           FOR UPDATE
    ) THEN
        RETURN 'user_not_found';
    END IF;

    UPDATE shards.text_users
       SET shard_id = i_new_shard_id
     WHERE uid = i_uid
       AND shard_id = i_shard_id;

    IF NOT FOUND THEN
        RETURN 'invalid_user_shard_id';
    END IF;

    RETURN 'success';
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION code.update_user(
    i_uid bigint,
    i_shard_id bigint,
    i_new_shard_id bigint,
    i_data jsonb
) RETURNS code.update_user_result AS $$
BEGIN
    IF NOT EXISTS(
        SELECT uid
          FROM shards.users
         WHERE uid = i_uid
           FOR UPDATE
    ) THEN
        RETURN 'user_not_found';
    END IF;

    UPDATE shards.users
       SET shard_id = i_new_shard_id,
           data = i_data
     WHERE uid = i_uid
       AND shard_id = i_shard_id;

    IF NOT FOUND THEN
        RETURN 'invalid_user_shard_id';
    END IF;

    RETURN 'success';
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION code.update_user(
    i_uid text,
    i_shard_id bigint,
    i_new_shard_id bigint,
    i_data jsonb
) RETURNS code.update_user_result AS $$
BEGIN
    BEGIN
        RETURN code.update_user(i_uid::bigint, i_shard_id, i_new_shard_id, i_data);
    EXCEPTION
        WHEN invalid_text_representation THEN
    END;

    IF NOT EXISTS(
        SELECT uid
          FROM shards.text_users
         WHERE uid = i_uid
           FOR UPDATE
    ) THEN
        RETURN 'user_not_found';
    END IF;

    UPDATE shards.text_users
       SET shard_id = i_new_shard_id,
           data = i_data
     WHERE uid = i_uid
       AND shard_id = i_shard_id;

    IF NOT FOUND THEN
        RETURN 'invalid_user_shard_id';
    END IF;

    RETURN 'success';
END;
$$ LANGUAGE plpgsql;
