CREATE OR REPLACE FUNCTION code.get_blocking_tasks(
    i_task transfer.task
) RETURNS transfer.task[] AS $$
    SELECT blocker FROM (
        SELECT dependent::transfer.task, blocker::transfer.task[]
          FROM (VALUES
                ('transfer', array['reset_passport_db', 'fix', 'call_sql', 'clone_user']),
                ('reset_passport_db', array['fix', 'call_sql', 'clone_user']),
                ('fix', NULL),
                ('call_sql', NULL),
                ('clone_user', NULL)
        ) AS v(dependent, blocker)
   ) deps WHERE dependent = i_task;
$$ LANGUAGE SQL IMMUTABLE;
