CREATE SCHEMA IF NOT EXISTS shards;

CREATE TABLE shards.shards
(
    shard_id integer NOT NULL,
    CONSTRAINT pk_shards PRIMARY KEY (shard_id)
);

CREATE TABLE shards.users
(
    uid bigint NOT NULL,
    shard_id integer NOT NULL REFERENCES shards.shards (shard_id) ON DELETE RESTRICT,
    CONSTRAINT pk_uids PRIMARY KEY (uid)
);

CREATE TABLE shards.instances
(
    instance_id integer NOT NULL,
    shard_id integer NOT NULL REFERENCES shards.shards (shard_id) ON DELETE CASCADE,
    host text NOT NULL,
    port integer NOT NULL,
    dc text NOT NULL,
    dbname text NOT NULL,
    CONSTRAINT pk_instances PRIMARY KEY (instance_id)
);

CREATE INDEX i_instance_shard_id ON shards.instances (shard_id);
