DROP INDEX IF EXISTS i_users_in_dogsleds_by_uid_not_null;
DROP INDEX IF EXISTS i_users_in_dogsleds_by_husky_id_uid_in_transfer;
DROP INDEX IF EXISTS i_users_in_dogsleds_by_husky_id_prioretized_pending;

CREATE UNIQUE INDEX i_users_in_dogsleds_by_uid_not_null_not_processed
    ON transfer.users_in_dogsleds (uid)
 WHERE uid IS NOT NULL
   AND (status = 'pending' OR status = 'in_transfer' OR status = 'reset_passport_db');

CREATE INDEX i_users_in_dogsleds_by_husky_id_status_prioretized
    ON transfer.users_in_dogsleds (husky_id, status, priority, last_update);

