CREATE TABLE shards.scopes (
    scope_id integer NOT NULL PRIMARY KEY,
    name text NOT NULL CHECK (name <> '')
);

CREATE TABLE shards.scopes_by_shards (
    id serial PRIMARY KEY,
    reg_weight integer NOT NULL DEFAULT 0,
    scope_id integer NOT NULL
        REFERENCES shards.scopes (scope_id) ON DELETE RESTRICT,
    shard_id integer NOT NULL
        REFERENCES shards.shards (shard_id) ON DELETE RESTRICT,

    UNIQUE (scope_id, shard_id)
);

CREATE INDEX i_scopes_by_shards_shard_id ON shards.scopes_by_shards (shard_id);
