CREATE EXTENSION IF NOT EXISTS "uuid-ossp";

CREATE TABLE conference_meta
(
    id            UUID      NOT NULL DEFAULT uuid_generate_v4(),
    short_url_id  TEXT      NOT NULL,
    conference_id TEXT      NOT NULL,
    shard_id      INT       NOT NULL,
    expired_at    TIMESTAMP NULL,

    CONSTRAINT pk_conferences_id PRIMARY KEY (id)
);

CREATE UNIQUE INDEX uk_conference_meta_conference_id ON conference_meta (conference_id);
CREATE INDEX conference_meta_short_url_id_index ON conference_meta (short_url_id);
CREATE INDEX conference_meta_shard_id_index ON conference_meta (shard_id);
