CREATE SCHEMA telemost;

CREATE EXTENSION IF NOT EXISTS "uuid-ossp";

CREATE TABLE telemost.conferences
(
    id                   UUID      NOT NULL DEFAULT uuid_generate_v4(),
    conference_id        TEXT      NOT NULL,
    conference_password  TEXT      NOT NULL,
    limit_type           TEXT      NOT NULL,
    created_at           timestamp NOT NULL,
    short_url_id         TEXT      NOT NULL,
    owner_uid            TEXT      NOT NULL,
    staff_only           boolean   NOT NULL,

    CONSTRAINT pk_conferences_id PRIMARY KEY (id)
);

CREATE UNIQUE INDEX uk_conferences_conference_id ON telemost.conferences (conference_id);
CREATE UNIQUE INDEX uk_conferences_short_url_id ON telemost.conferences (short_url_id);

