CREATE TABLE telemost.user_data
(
    id                   UUID      NOT NULL DEFAULT uuid_generate_v4(),
    conference_id        UUID      NOT NULL,
    user_id              TEXT      NOT NULL,
    uid                  TEXT,

    CONSTRAINT pk_user_data_id PRIMARY KEY (id),
    CONSTRAINT fk_user_data_conferences FOREIGN KEY (conference_id) REFERENCES telemost.conferences ON DELETE RESTRICT
);

CREATE UNIQUE INDEX uk_user_data_conference_id_user_id ON telemost.user_data (conference_id, user_id);

CREATE INDEX idx_conference_id_uid ON telemost.user_data (conference_id, uid);
