ALTER TABLE telemost.conferences ADD COLUMN is_yateam boolean NOT NULL DEFAULT FALSE;

CREATE TABLE telemost.user_token
(
    id                   UUID      NOT NULL DEFAULT uuid_generate_v4(),
    conference_id        UUID      NOT NULL,
    uid                  TEXT,
    token                TEXT      NOT NULL,
    created_at           timestamp NOT NULL,
    status               TEXT      NOT NULL,

    CONSTRAINT pk_user_token_id PRIMARY KEY (id),
    CONSTRAINT fk_user_token_conferences FOREIGN KEY (conference_id) REFERENCES telemost.conferences ON DELETE RESTRICT
);

CREATE UNIQUE INDEX uk_user_token_conference_id_uid_created_at ON telemost.user_token (conference_id, uid, created_at);

