CREATE TABLE telemost.user_state
(
    id           UUID      NOT NULL DEFAULT uuid_generate_v4(),
    created_at   timestamp NOT NULL,
    user_data_id UUID      NOT NULL,
    version      numeric   not null,
    state        JSONB     NOT NULL,

    CONSTRAINT pk_user_state_id PRIMARY KEY (id),
    CONSTRAINT fk_user_data FOREIGN KEY (user_data_id) REFERENCES telemost.user_data ON DELETE RESTRICT

);

CREATE UNIQUE INDEX idx_user_data_id ON telemost.user_state (user_data_id);
