DROP INDEX telemost.idx_conference_id_uid;
CREATE INDEX idx_conference_id_uid ON telemost.user_data (conference_id, uid);

ALTER TABLE telemost.user_data ADD COLUMN peer_token text NULL;

CREATE TABLE telemost.media_sessions
(
    id                   UUID      NOT NULL DEFAULT uuid_generate_v4(),
    media_session_id     TEXT      NOT NULL,
    user_id              UUID      NOT NULL,
    disconnected_at      TIMESTAMP,
    client_instance_id   TEXT,

    CONSTRAINT pk_media_sessions_id PRIMARY KEY (id),
    CONSTRAINT fk_media_sessions_user_data FOREIGN KEY (user_id) REFERENCES telemost.user_data ON DELETE RESTRICT
);

CREATE INDEX idx_media_sessions_client_instance_id_disconnected_at ON telemost.media_sessions (client_instance_id, disconnected_at);
CREATE UNIQUE INDEX idx_media_sessions_user_id_media_session_id ON telemost.media_sessions (user_id, media_session_id);

