/* pgmigrate-encoding: utf-8 */

CREATE TABLE telemost.conference_users
(
    id            UUID NOT NULL default uuid_generate_v4(),
    conference_id UUID NOT NULL,
    role          TEXT NOT NULL,
    uid           TEXT NOT NULL,
    CONSTRAINT conference_user_pk primary key (id),
    CONSTRAINT fk_conferences FOREIGN KEY (conference_id) REFERENCES telemost.conferences ON DELETE RESTRICT
);

CREATE INDEX conference_index ON telemost.conference_users (conference_id);
CREATE UNIQUE INDEX conference_uid_index ON telemost.conference_users (conference_id, uid);

INSERT INTO telemost.conference_users (conference_id, uid, role)
SELECT c.id, 'OWNER', c.owner_uid FROM telemost.conferences c
WHERE c.owner_uid IS NOT NULL;

INSERT INTO telemost.conference_users (conference_id, uid, role)
SELECT ud.conference_id, ud.uid, 'MEMBER' FROM telemost.user_data ud
WHERE ud.uid IS NOT NULL
ON CONFLICT DO NOTHING;
