/* pgmigrate-encoding: utf-8 */

ALTER TABLE telemost.conference_state ADD translation_allowed BOOLEAN NOT NULL DEFAULT FALSE;

CREATE TABLE telemost.translations
(
    id                  UUID      NOT NULL DEFAULT uuid_generate_v4(),
    conference_id       UUID      NOT NULL,
    created_at          TIMESTAMP NOT NULL DEFAULT now(),
    created_by          TEXT      NOT NULL,
    translation_key     TEXT      NOT NULL,
    translation_chat_id UUID      NOT NULL,

    CONSTRAINT pk_translation_id PRIMARY KEY (id),
    CONSTRAINT fk_conferences FOREIGN KEY (conference_id) REFERENCES telemost.conferences ON DELETE RESTRICT
);

CREATE UNIQUE INDEX idx_translation_key ON telemost.translations(translation_key);

CREATE TABLE telemost.streams
(
    id                          UUID        NOT NULL DEFAULT uuid_generate_v4(),
    translation_id              UUID        NOT NULL,
    ugc_live_url                TEXT        NOT NULL,
    owner_uid                   TEXT,
    started_at                  TIMESTAMP,
    stopped_at                  TIMESTAMP,
    translator                  TEXT,
    translator_token            TEXT,
    rtmp_key                    TEXT,
    translator_last_keep_alive  TIMESTAMP,
    created_at                  TIMESTAMP   NOT NULL DEFAULT now(),

    CONSTRAINT pk_stream_id PRIMARY KEY (id),
    CONSTRAINT fk_translations FOREIGN KEY (translation_id) REFERENCES telemost.translations ON DELETE RESTRICT
);

CREATE UNIQUE INDEX idx_started_at ON telemost.streams(started_at);

CREATE TABLE telemost.users
(
    uid                     TEXT        NOT NULL,
    created_at              TIMESTAMP   NOT NULL DEFAULT now(),
    updated_at              TIMESTAMP   NOT NULL DEFAULT now(),
    translations_enabled    BOOLEAN     NOT NULL DEFAULT FALSE,

    CONSTRAINT pk_uid PRIMARY KEY (uid)
);
