/* pgmigrate-encoding: utf-8 */

CREATE UNIQUE INDEX idx_translation_conference_id ON telemost.translations(conference_id);

INSERT INTO telemost.users (uid)
SELECT uid FROM telemost.conference_users
ON CONFLICT DO NOTHING;

ALTER TABLE telemost.conference_users
    ADD CONSTRAINT fk_uid FOREIGN KEY (uid) REFERENCES telemost.users ON DELETE RESTRICT;


INSERT INTO telemost.users (uid)
SELECT uid FROM telemost.user_data
WHERE uid IS NOT NULL ON CONFLICT DO NOTHING;

ALTER TABLE telemost.user_data
    ADD CONSTRAINT fk_uid FOREIGN KEY (uid) REFERENCES telemost.users ON DELETE RESTRICT;


INSERT INTO telemost.users (uid)
SELECT uid FROM telemost.user_token
WHERE uid IS NOT NULL ON CONFLICT DO NOTHING;

ALTER TABLE telemost.user_token
    ADD CONSTRAINT fk_uid FOREIGN KEY (uid) REFERENCES telemost.users ON DELETE RESTRICT;


ALTER TABLE telemost.translations
    ADD CONSTRAINT fk_created_by FOREIGN KEY (created_by) REFERENCES telemost.users ON DELETE RESTRICT;

ALTER TABLE telemost.streams
    ADD CONSTRAINT fk_owner_uid FOREIGN KEY (owner_uid) REFERENCES telemost.users ON DELETE RESTRICT;
