/* pgmigrate-encoding: utf-8 */

CREATE TABLE telemost.broadcasts
(
    id                  UUID      NOT NULL DEFAULT uuid_generate_v4(),
    conference_id       UUID      NOT NULL,
    created_at          TIMESTAMP NOT NULL DEFAULT now(),
    created_by          TEXT      NOT NULL,
    broadcast_key       TEXT      NOT NULL,
    broadcast_chat_id   UUID      NOT NULL,
    ugc_live_line_id    BIGINT,

    CONSTRAINT pk_broadcast_id PRIMARY KEY (id),
    CONSTRAINT fk_conferences FOREIGN KEY (conference_id) REFERENCES telemost.conferences ON DELETE RESTRICT,
    CONSTRAINT fk_created_by FOREIGN KEY (created_by) REFERENCES telemost.users ON DELETE RESTRICT
);

CREATE UNIQUE INDEX idx_broadcast_key ON telemost.broadcasts(broadcast_key);
CREATE UNIQUE INDEX idx_broadcast_conference_id ON telemost.broadcasts(conference_id);

INSERT INTO telemost.broadcasts (
    id, conference_id, created_at, created_by, broadcast_key, broadcast_chat_id, ugc_live_line_id
)
SELECT id, conference_id, created_at, created_by, translation_key, translation_chat_id, ugc_live_line_id
FROM telemost.translations;

ALTER TABLE telemost.streams ADD COLUMN broadcast_id UUID;
ALTER TABLE telemost.streams ADD CONSTRAINT fk_broadcasts FOREIGN KEY (broadcast_id) REFERENCES telemost.broadcasts ON DELETE RESTRICT;

UPDATE telemost.streams SET broadcast_id = translation_id;

ALTER TABLE telemost.streams ALTER COLUMN translation_id DROP NOT NULL;
