#!/usr/bin/env python

import logging
import yt.wrapper as yt
import psycopg2
import socket
from psycopg2.extras import RealDictCursor
import time

def main():
    logging.basicConfig(
        level=logging.DEBUG,
        format='%(asctime)s [%(levelname)s] %(name)s:\t%(message)s')
    log = logging.getLogger('main')

    dt = time.strftime("%Y-%m-%d")
    table = "//home/disk-stat/ucache/dataapi/" + dt
    conn_str = 'dbname=postgres port=5432'
    conn = psycopg2.connect(conn_str)
    log.debug('success on connect to postgresql')
    schema = [
        {"name": "uid",         "type": "int64"},
        {"name": "calls",       "type": "int64"},
        {"name": "reads",       "type": "int64"},
        {"name": "reads_blks",  "type": "int64"},
        {"name": "writes",      "type": "int64"},
        {"name": "writes_blks", "type": "int64"},
        {"name": "user_time",   "type": "double"},
        {"name": "system_time", "type": "double"},
        {"name": "hostname",    "type": "string"},
        {"name": "dt",          "type": "string"},
    ]
    ucache = u"""
           select uid, calls,
                  reads, reads_blks,
                  writes, writes_blks,
                  user_time, system_time,
                  %(hostname)s hostname,
                  %(dt)s dt
             from pg_stat_ucache
           """
    cur = conn.cursor(cursor_factory=RealDictCursor)
    cur.execute(ucache,{'hostname': socket.getfqdn(), 'dt': dt} )
    log.debug('success on fetch ucache')
    yt.update_config({'proxy': {'url': "hahn.yt.yandex.net"}})

    if not yt.exists(table):
        yt.create_table(table, attributes={"schema": schema})
        log.debug('create new yt table')
    try:
        yt.write_table((yt.TablePath(table, append=True)), cur, format="json", raw=False)
    except yt.errors.YtHttpResponseError as e:
        log.error(e)
    else:
        log.debug('success on write to yt')
        cur.execute('select pg_stat_ucache_reset()')
        log.debug('success on reset to ucache')

if __name__ == "__main__":
    main()
