#!/bin/sh

export s_host=`hostname -f`
export s_port=5432
export p_db=api_disk_data
export psql=/usr/bin/psql

ts=`/bin/date +%s`
hn=`/bin/hostname -f | tr '.-' '__'`

dbsize=$(su postgres -c "cd ~; echo \"SELECT \\
         SUM(CAST ( size AS bigint))\\
         FROM ( SELECT pg_total_relation_size(oid) as size \\
                FROM ( SELECT oid \\
                        FROM pg_catalog.pg_class \\
                        WHERE relname NOT LIKE 'deltas_%'\\
                        AND relkind = 'r'
                 )\\
        oid) AS s;\" | psql -t -A ${p_db} | grep -E '^[0-9]+$'"\\
 2>/dev/null )

echo "disk.pg."${hn}".db.apidb.no_delta_size "${dbsize}" "${ts}
