{% set dbname = 'api_disk_data' %}
{% set target = salt['pillar.get']('data:api_disk_data:target', 'latest') %}
{% set databases = salt['pillar.get']('data:api_disk_data:databases', ['api_disk_data']) %}
{% set path = salt['pillar.get']('data:dbfiles_path', '/usr/local/yandex/') %}

{# Remember that the order is important! #}
{% 
    set sqls = [
        'common/dynamic_query.sql',
        'common/is_master.sql'
    ]
%}

{% for sql in sqls %}
{{ dbname + path + sql }}:
    file.managed:
        - name: {{ path + sql }}
        - source: salt://components/pg-code/{{ sql }}
        - user: postgres
        - template: jinja
        - mode: 744
        - makedirs: True
        - require:
            - service: postgresql-service
{% endfor %}

{{ path + dbname }}:
    file.recurse:
        - source: salt://components/pg-code/dataapidb
        - user: postgres
        - template: jinja
        - dir_mode: 755
        - file_mode: 744
        - makedirs: True
        - clean: True
        - require:
            - service: postgresql-service
        - defaults:
            default_dbname: {{ dbname }}

{% for database in databases %}
{% if salt['grains.get']('pg') and 'role' in salt['grains.get']('pg').keys() and salt['grains.get']('pg')['role'] == 'master' %}

create_db_{{ database }}:
    postgres_database.present:
        - name: {{ database }}
        - user: postgres
        - require:
            - cmd: postgresql-service
            - postgres_user: postgres-user-dataapi

create_repl_mon_fdw_{{ database }}:
    postgresql_cmd.psql_file:
        - name: /usr/local/yandex/sqls/repl_mon.sql
        - maintenance_db: {{ database }}
        - require:
            - postgres_database: create_db_{{ database }}
            - file: /usr/local/yandex/sqls/repl_mon.sql
        - unless:
            - -c "SELECT c.relname FROM pg_catalog.pg_foreign_table ft INNER JOIN pg_catalog.pg_class c ON c.oid = ft.ftrelid;" | grep repl_mon

{{ database + '-schemas-apply' }}:
    postgresql_schema.applied:
        - name: {{ dbname }}
        - target: {{ target }}
        - conn: 'dbname={{ database }}\ user=postgres\ connect_timeout=1'
        - callbacks:
            afterAll:
{% for sql in sqls %}
                - {{ path + sql }}
{% endfor %}
                - {{ path + dbname }}/grants
        - require:
            - postgres_database: create_db_{{ dbname }}
            - pkg: yamail-pgmigrate
            - file: {{ path + dbname }}
{% for sql in sqls %}
            - file: {{ path + sql }}
{% endfor %}
{% endif %}
{% endfor %}

{% if salt['pillar.get']('data:yt:ucache', False ) %}
/etc/logrotate.d/mdb_ucache_yt:
    file.managed:
        - template: jinja
        - source: salt://components/pg-dbs/apidb/conf/mdb_ucache_yt.logrotate
        - mode: 644
        - user: root
        - group: root

/etc/cron.yandex/mdb_ucache_yt.py:
    file.managed:
        - template: jinja
        - source: salt://components/pg-dbs/apidb/conf/mdb_ucache_yt.py
        - user: postgres
        - group: postgres
        - mode: 744
        - require:
            - file: /etc/cron.yandex

/var/log/mdb_ucache_yt.log:
    file.managed:
        - user: postgres
        - group: postgres
        - replace: False
        - mode: 640

yt-python:
    pkg.installed:
{% if salt['grains.get']('os') == 'Ubuntu' %}
        - name: yandex-yt-python
        - version: '0.8.11-0'
{% else %}
        - name: yandex-yt
        - version: '0.8.5-5yandex.el6'
{% endif %}

/var/lib/postgresql/.yt/token:
    file.managed:
        - template: jinja
        - user: postgres
        - group: postgres
        - dir_mode: 0700
        - makedirs: True
        - mode: 400
        - contents_pillar: data:config:disk-stat-yt-token

/etc/cron.d/mdb_ucache:
    file.managed:
        - template: jinja
        - source: salt://components/pg-dbs/apidb/conf/mdb_ucache
        - user: root
        - group: root
        - mode: 644
        - watch_in:
            - service: pg-common-configs-crond-reload
{% endif %}

include:
    - .graphite.add_selective_scripts
    - .mdb-metrics
