{% set dbname = 'dbaas_metadb' %}
{% set target = salt['pillar.get']('data:dbaas_metadb:target', 'latest') %}
{% set databases = salt['pillar.get']('data:dbaas_metadb:databases', ['dbaas_metadb']) %}
{% set path = salt['pillar.get']('data:dbfiles_path', '/usr/local/yandex/') %}

{% if salt['pillar.get']('data:dbaas_metadb:enable_cleaner', True) %}
include:
    - .dbaas_cleaner
{% endif %}

{# Remember that the order is important! #}
{% 
    set sqls = [
        'common/dynamic_query.sql',
        'common/is_master.sql'
    ]
%}

{% for sql in sqls %}
{{ dbname + path + sql }}:
    file.managed:
        - source: salt://components/pg-code/{{ sql }}
        - name: {{ path + sql }}
        - user: postgres
        - template: jinja
        - mode: 744
        - makedirs: True
        - require:
            - cmd: postgresql-service
{% endfor %}

{{ path + dbname }}:
    file.recurse:
        - source: salt://components/pg-code/{{ dbname }}
        - user: postgres
        - dir_mode: 755
        - file_mode: 744
        - makedirs: True
        - clean: True
        - exclude_pat: 'E@(.git)|(tests)'
        - require:
            - service: postgresql-service
        - defaults:
            default_dbname: {{ dbname }}

/etc/mdb-metrics/conf.d/available/dbaas_metadb_quotas.conf:
    file.managed:
        - source: salt://{{ slspath }}/conf/dbaas_metadb_quotas.conf
        - mode: 644
        - makedirs: True
        - require:
            - pkg: mdb-metrics-pkg
        - require_in:
            - file: /etc/mdb-metrics/conf.d/enabled/dbaas_metadb_quotas.conf
        - watch_in:
            - service: mdb-metrics-service

/etc/mdb-metrics/conf.d/enabled/dbaas_metadb_quotas.conf:
    file.symlink:
        - target: /etc/mdb-metrics/conf.d/available/dbaas_metadb_quotas.conf
        - watch_in:
            - service: mdb-metrics-service

{{ path + dbname + '_flavors.json' }}:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/flavors.json
        - mode: 644
        - require:
            - file: {{ path + dbname }}

{{ path + dbname + '_geos.json' }}:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/geos.json
        - mode: 644
        - require:
            - file: {{ path + dbname }}

{{ path + dbname + '_cluster_type_pillars.json' }}:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/cluster_type_pillars.json
        - mode: 644
        - require:
            - file: {{ path + dbname }}

{{ path + dbname + '_default_feature_flags.json' }}:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/default_feature_flags.json
        - mode: 644
        - require:
            - file: {{ path + dbname }}

{% for database in databases %}
{% if salt['grains.get']('pg') and 'role' in salt['grains.get']('pg').keys() and salt['grains.get']('pg')['role'] == 'master' %}

create_db_{{ database }}:
    postgres_database.present:
        - name: {{ database }}
        - user: postgres
        - require:
            - cmd: postgresql-service
            - postgres_user: postgres-user-dbaas_api
            - postgres_user: postgres-user-dbaas_worker

create_repl_mon_fdw_{{ database }}:
    postgresql_cmd.psql_file:
        - name: /usr/local/yandex/sqls/repl_mon.sql
        - maintenance_db: {{ database }}
        - require:
            - postgres_database: create_db_{{ database }}
            - file: /usr/local/yandex/sqls/repl_mon.sql
        - unless:
            - -c "SELECT c.relname FROM pg_catalog.pg_foreign_table ft INNER JOIN pg_catalog.pg_class c ON c.oid = ft.ftrelid;" | grep repl_mon

{{ database + '-schemas-apply' }}:
    postgresql_schema.applied:
        - name: {{ dbname }}
        - target: {{ target }}
        - conn: 'dbname={{ database }}\ user=postgres\ connect_timeout=1'
        - callbacks:
            afterAll:
{% for sql in sqls %}
                - {{ path + sql }}
{% endfor %}
                - {{ path + dbname }}/code
                - {{ path + dbname }}/grants
        - require:
            - postgres_database: create_db_{{ dbname }}
            - pkg: yamail-pgmigrate
            - file: {{ path + dbname }}
{% for sql in sqls %}
            - file: {{ path + sql }}
{% endfor %}

{{ database + '-flavors-set' }}:
    cmd.run:
        - name: python2 {{ path + dbname + '/bin/populate_table.py' }} -f {{ path + dbname + '_flavors.json' }} -t dbaas.flavors
        - runas: postgres
        - onchanges:
            - postgresql_schema: {{ database + '-schemas-apply' }}
            - file: {{ path + dbname + '_flavors.json' }}

{{ database + '-geos-set' }}:
    cmd.run:
        - name: python2 {{ path + dbname + '/bin/populate_table.py' }} -f {{ path + dbname + '_geos.json' }} -t dbaas.geo
        - runas: postgres
        - onchanges:
            - postgresql_schema: {{ database + '-schemas-apply' }}
            - file: {{ path + dbname + '_geos.json' }}

{{ database + '-cluster-type-pillars-set' }}:
    cmd.run:
        - name: python2 {{ path + dbname + '/bin/populate_table.py' }} -f {{ path + dbname + '_cluster_type_pillars.json' }} -t dbaas.cluster_type_pillar -k type
        - runas: postgres
        - onchanges:
            - postgresql_schema: {{ database + '-schemas-apply' }}
            - file: {{ path + dbname + '_cluster_type_pillars.json' }}

{{ database + '-default-feature-flags-set' }}:
    cmd.run:
        - name: python2 {{ path + dbname + '/bin/populate_table.py' }} -f {{ path + dbname + '_default_feature_flags.json' }} -t dbaas.default_feature_flags -k flag_name
        - runas: postgres
        - onchanges:
            - postgresql_schema: {{ database + '-schemas-apply' }}
            - file: {{ path + dbname + '_default_feature_flags.json' }}
{% endif %}
{% endfor %}
