{% set dbname = 'dbm' %}
{% set target = salt['pillar.get']('data:dbm:target', 'latest') %}
{% set path = salt['pillar.get']('data:dbfiles_path', '/usr/local/yandex/') %}

{{ path + dbname }}:
    file.recurse:
        - source: salt://components/pg-code/dbmdb
        - user: postgres
        - template: jinja
        - dir_mode: 755
        - file_mode: 744
        - makedirs: True
        - clean: True
        - require:
            - service: postgresql-service
        - defaults:
            default_dbname: {{ dbname }}

/etc/mdb-metrics/conf.d/available/dbm_pgaas_resources.conf:
    file.managed:
        - source: salt://{{ slspath }}/conf/dbm_pgaas_resources.conf
        - mode: 644
        - makedirs: True
        - require:
            - pkg: mdb-metrics-pkg
        - require_in:
            - file: /etc/mdb-metrics/conf.d/enabled/dbm_pgaas_resources.conf
        - watch_in:
            - service: mdb-metrics-service

/etc/mdb-metrics/conf.d/enabled/dbm_pgaas_resources.conf:
    file.symlink:
        - target: /etc/mdb-metrics/conf.d/available/dbm_pgaas_resources.conf
        - watch_in:
            - service: mdb-metrics-service

{% if salt['grains.get']('pg') and 'role' in salt['grains.get']('pg').keys() and salt['grains.get']('pg')['role'] == 'master' %}
create_db_{{ dbname }}:
    postgres_database.present:
        - name: {{ dbname }}
        - user: postgres
        - require:
            - cmd: postgresql-service
            - postgres_user: postgres-user-dbm

{{ dbname + '-schemas-apply' }}:
    postgresql_schema.applied:
        - name: {{ dbname }}
        - target: {{ target }}
        - conn: 'dbname={{ dbname }}\ user=postgres\ connect_timeout=1'
        - callbacks:
            afterAll:
                - {{ path + dbname }}/grants
        - require:
            - postgres_database: create_db_{{ dbname }}
            - pkg: yamail-pgmigrate
            - file: {{ path + dbname }}
{% endif %}
