{% set dbname = 'diskdb' %}
{% set target = salt['pillar.get']('data:pgaas:' ~ dbname ~ ':target', 'latest') %}
{% set user = salt['pillar.get']('data:pgaas:' ~ dbname ~ ':user', dbname) %}
{% set runas = salt['pillar.get']('data:pgaas:' ~ dbname ~ ':runas', 'postgres') %}
{% set db_instances = salt['pillar.get']('data:pgaas:' ~ dbname ~ ':dbs', []) %}
{% set basepath = salt['pillar.get']('data:pgaas:dbfiles_path', '/usr/local/yandex/pgaas') %}
{% set path = basepath ~ '/' ~ dbname %}

{{ path }}:
    file.recurse:
        - source: salt://components/pg-code/{{ dbname }}
        - user: root
        - template: jinja
        - dir_mode: 755
        - file_mode: 744
        - exclude_pat: 'E@(.git)'
        - makedirs: True
        - clean: True

{% for instance in db_instances %}
{{ dbname ~ '-' ~ instance ~ '-schemas-apply' }}:
    postgresql_schema.applied:
        - name: {{ dbname }}
        - base: {{ basepath }}
        - target: {{ target }}
        - runas: {{ runas }}
        - conn: 'dbname={{ instance }}\ user={{user}}\ host=pgaas.mail.yandex.net\ port=12000\ connect_timeout=1'
        - callbacks:
            afterAll:
                - {{ path }}/code
                - {{ path }}/grants
        - require:
            - pkg: yamail-pgmigrate
            - file: {{ path }}
{% endfor %}
