{% set dbname = salt['pillar.get']('data:dbname', 'diskdb') %}
{% set target = salt['pillar.get']('data:diskdb:target', 'latest') %}
{% set path = salt['pillar.get']('data:dbfiles_path', '/usr/local/yandex/') %}

include:
  - .mdb-metrics
{% if salt['pillar.get']('data:yt:ucache', False ) %}
  - components.pg-dbs.common.dump_yt
{% endif %}

{# Remember that the order is important! #}
{% 
    set sqls = [
        'common/is_master.sql'
    ]
%}

{% for sql in sqls %}
{{ dbname + path + sql }}:
    file.managed:
        - source: salt://components/pg-code/{{ sql }}
        - name: {{ path + sql }}
        - user: postgres
        - template: jinja
        - mode: 744
        - makedirs: True
        - require:
            - cmd: postgresql-service
{% endfor %}

{{ path + dbname }}:
    file.recurse:
        - source: salt://components/pg-code/{{ dbname }}
        - user: postgres
        - template: jinja
        - dir_mode: 755
        - file_mode: 744
        - makedirs: True
        - clean: True
        - require:
            - service: postgresql-service
        - defaults:
            default_dbname: {{ dbname }}
        - exclude_pat: .git*

{% if salt['grains.get']('pg') and 'role' in salt['grains.get']('pg').keys() and salt['grains.get']('pg')['role'] == 'master' %}

create_db_{{ dbname }}:
    postgres_database.present:
        - name: {{ dbname }}
        - user: postgres
        - require:
            - cmd: postgresql-service
            - postgres_user: postgres-user-disk_mpfs

create_repl_mon_fdw_{{ dbname }}:
    postgresql_cmd.psql_file:
        - name: /usr/local/yandex/sqls/repl_mon.sql
        - maintenance_db: {{ dbname }}
        - require:
            - postgres_database: create_db_{{ dbname }}
            - file: /usr/local/yandex/sqls/repl_mon.sql
        - unless:
            - -c "SELECT c.relname FROM pg_catalog.pg_foreign_table ft INNER JOIN pg_catalog.pg_class c ON c.oid = ft.ftrelid;" | grep repl_mon

{{ dbname + '-schemas-apply' }}:
    postgresql_schema.applied:
        - name: {{ dbname }}
        - target: {{ target }}
        - termination_interval: 0.2
        - conn: 'dbname={{ dbname }}\ user=postgres\ connect_timeout=1'
        - callbacks:
            afterAll:
{% for sql in sqls %}
                - {{ path + sql }}
{% endfor %}
                - {{ path + dbname }}/code
                - {{ path + dbname }}/grants
        - require:
            - postgres_database: create_db_{{ dbname }}
            - pkg: yamail-pgmigrate
            - file: {{ path + dbname }}
{% for sql in sqls %}
            - file: {{ path + sql }}
{% endfor %}
{% endif %}

{% if salt['pillar.get']('data:yt:ucache', False ) %}
/etc/logrotate.d/mdb_ucache_yt:
    file.managed:
        - template: jinja
        - source: salt://components/pg-dbs/diskdb/conf/mdb_ucache_yt.logrotate
        - mode: 644
        - user: root
        - group: root

/etc/cron.yandex/mdb_ucache_yt.py:
    file.managed:
        - template: jinja
        - source: salt://components/pg-dbs/diskdb/conf/mdb_ucache_yt.py
        - user: postgres
        - group: postgres
        - mode: 744
        - require:
            - file: /etc/cron.yandex

/var/log/mdb_ucache_yt.log:
    file.managed:
        - user: postgres
        - group: postgres
        - replace: False
        - mode: 640

/var/lib/postgresql/.yt/token:
    file.managed:
        - template: jinja
        - user: postgres
        - group: postgres
        - dir_mode: 0700
        - makedirs: True
        - mode: 400
        - contents_pillar: data:config:disk-stat-yt-token

/etc/cron.d/mdb_ucache:
    file.managed:
        - template: jinja
        - source: salt://components/pg-dbs/diskdb/conf/mdb_ucache
        - user: root
        - group: root
        - mode: 644
        - watch_in:
            - service: pg-common-configs-crond-reload
{% endif %}
