{% set dbname = 'dsdb' %}

include:
    - components.pg-dbs.pgmeta.ugly

{% if salt['grains.get']('pg') and 'role' in salt['grains.get']('pg').keys() and salt['grains.get']('pg')['role'] == 'master' %}

create_db_{{ dbname }}:
    postgres_database.present:
        - name: {{ dbname }}
        - user: postgres
        - owner: disk_admin
        - require:
            - cmd: postgresql-service
            - postgres_user: postgres-user-disk_admin

create_repl_mon_fdw_{{ dbname }}:
    postgresql_cmd.psql_file:
        - name: /usr/local/yandex/sqls/repl_mon.sql
        - maintenance_db: {{ dbname }}
        - require:
            - postgres_database: create_db_{{ dbname }}
            - file: /usr/local/yandex/sqls/repl_mon.sql
        - unless:
            - -c "SELECT c.relname FROM pg_catalog.pg_foreign_table ft INNER JOIN pg_catalog.pg_class c ON c.oid = ft.ftrelid;" | grep repl_mon
{% endif %}
